#!/bin/sh

srcdir=${srcdir-..}
testdir=${srcdir}/tests

if [ ! -d ${srcdir} ]; then
    echo ${srcdir} does not exist!
    exit 1
fi

if [ ! -d ${testdir} ]; then
    echo ${testdir} does not exist!
    exit 1
fi

for i in ${srcdir}/ChangeLog.* ${testdir}/*.test; do
    oldname=$(echo $i | sed -e "s,${srcdir}/,,")
    newname=$oldname

    case $oldname in
	ChangeLog.*)
	    newname=$(echo $oldname \
		| sed -e 's,\.[0-9][0-9]\([0-9][0-9]\)$,.\1,')
	    ;;

	tests/aclocal*.test)
	    newname=$(echo $oldname \
		| sed 's,aclocal\([a-z0-9]*\),aclocl\1,')
	    ;;

	tests/acoutput*.test)
	    newname=$(echo $oldname \
		| sed 's,acoutput\([0-9]*\),acoutpt\1,')
	    ;;

	tests/autoheader*.test)
	    newname=$(echo $oldname \
		| sed 's,autoheader\([0-9]*\),autohed\1,')
	    ;;

	tests/condincl*.test)
	    newname=$(echo $oldname \
		| sed 's,condincl\([0-9]*\),condinc\1,')
	    ;;

	tests/distcommon*.test)
	    newname=$(echo $oldname \
		| sed 's,distcommon\([0-9]*\),distcom\1,')
	    ;;

	tests/instdata*.test)
	    newname=$(echo $oldname \
		| sed 's,instdata\([0-9]*\),instdat\1,')
	    ;;

	tests/installsh*.test)
	    newname=$(echo $oldname \
		| sed 's,installsh\([0-9]*\),instsh\1,')
	    ;;

	tests/libobj*.test)
	    newname=$(echo $oldname \
		| sed 's,libobj\([0-9]*[a-z]*\),libob\1,')
	    ;;

	tests/link_f_c*.test)
	    newname=$(echo $oldname \
		| sed 's,link_f_c\([a-z_]*\),l_f_c\1,')
	    ;;

	tests/nodefine*.test)
	    newname=$(echo $oldname \
		| sed 's,nodefine\([0-9]*\),nodef\1,')
	    ;;

	tests/required*.test)
	    newname=$(echo $oldname \
		| sed 's,required\([0-9]*\),require\1,')
	    ;;

	tests/sourcesub*.test)
	    newname=$(echo $oldname \
		| sed 's,sourcesub\([0-9]*\),srcsub\1,')
	    ;;

	tests/specflags*.test)
	    newname=$(echo $oldname \
		| sed 's,specflags\([0-9]*\),specflg\1,')
	    ;;

	tests/subdircond*.test)
	    newname=$(echo $oldname \
		| sed 's,subdircond\([0-9]*\),subcond\1,')
	    ;;

	tests/texinfo*.test)
	    newname=$(echo $oldname \
		| sed 's,texinfo\([0-9]*\),txinfo\1,')
	    ;;

	*)
	    ;;
    esac

    echo $oldname $newname
done
