if ! test -f Makefile.ori; then
  echo Saving the original file 'Makefile.in' to 'Makefile.ori'
  cp -p Makefile.in Makefile.ori
fi

# Change the 'editsh' sed's in Makefile.in to have in the
# resulting 'auto...' scripts the variable ${DJDIR} and not
# the expanded variable, so the script is portable to different
# computers, where DJDIR is in most cases different.
# This is, because on MS-DOS you don't have a default directory
# tree like under unix.
# Change also the *.info* to *.inf*, because this will fail, if
# we are not using long filenames

sed -e 's,\*\.info\*,\*\.inf\*,g' -e "s!,\\\$(AWK),g.*\$!& -e 's,\\\$(DJDIR),\\\$\\\${DJDIR},g'!g" Makefile.ori > Makefile.in

# Change the IFS to take care of bash's PATH_SEPARATOR
# It defaults to ';'
# Change the 'test -f' to 'test -x' since only 'test -x' will
# return correct test on executables when testing a file without
# a suffix
# Example for testing of $DJDIR/bin/m4.exe
# test -f $DJDIR/bin/m4 will fail, but
# test -x $DJDIR/bin/m4 will succeed
#
# These sed's have to be done for 'acgeneral.m4' and 'acspecific.m4'

if ! test -f acgeneral.ori; then
  echo Saving the original file 'acgeneral.m4' to 'acgeneral.ori'
  cp -p acgeneral.m4 acgeneral.ori
fi

sed -e 's,IFS}:,IFS}\${PATH_SEPARATOR-\;},g' -e 's,test -f \$ac_dir/\$ac_word,test -x \$ac_dir/\$ac_word,g' acgeneral.ori > acgeneral.m4

if ! test -f acspecific.ori; then
  echo Saving the original file 'acspecific.m4' to 'acspecific.ori'
  cp -p acspecific.m4 acspecific.ori
fi

sed -e 's,IFS}:,IFS}\${PATH_SEPARATOR-\;},g' -e 's,test -f \$ac_dir/\$ac_prog,test -x \$ac_dir/\$ac_prog,g' acspecific.ori > acspecific.m4

# give configure a hint about these programs
export AWK=awk
export INSTALL=ginstall

# now run the configure script. The prefix arguments allows to have in the
# Makefile the variable ${DJDIR} and not it's expanded contents

bash ./configure --prefix=\${DJDIR}
