#define Uses_TRect
#define Uses_TDialog
#define Uses_TScrollBar
#define Uses_TButton
#define Uses_TDeskTop
#define Uses_TApplication
#define Uses_TProgram
#define Uses_TCollection
#define Uses_TListBox
#define Uses_TCEditWindow
#include <ceditor.h>
#include <dskwin.h>
#include <edcollec.h>
#include <editcoma.h>

TView *setFocusTo;
Boolean focusChanged;
TEditorCollection *edHelper=NULL;

class TListWindowsDiag : public TDialog
{
public:
 TListWindowsDiag(TRect sizeDkt);
 void handleEvent(TEvent &event);
 TListEditors *tl;
};

TListWindowsDiag::TListWindowsDiag(TRect sizeDkt) :
 TDialog(sizeDkt,_("Windows List")),
 TWindowInit(TListWindowsDiag::initFrame)
{
 helpCtx = hcListWin;

 int h=sizeDkt.b.y-sizeDkt.a.y;
 int w=sizeDkt.b.x-sizeDkt.a.x;

 TScrollBar *sb = new TScrollBar( TRect(w-3,2,w-2,h-4) );
 insert(sb);
 tl = new TListEditors(TRect(2,2,w-3,h-4),1,sb);
 tl->newList(edHelper);
 insert(tl);

 TRect r(3,h-3,15,h-1);
 insert( new TButton(r,_("~G~o"),cmGo,bfDefault) );
 r.move(14,0);
 insert( new TButton(r,_("~D~elete"),cmDelete,bfNormal) );
 r.move(14,0);
 insert( new TButton(r,_("Cancel"),cmCancel,bfNormal) );

 selectNext( False );
 options |= ofCentered;
}

void TListWindowsDiag::handleEvent(TEvent &event)
{
 TDialog::handleEvent(event);
 switch (event.what)
   {
    case evCommand:
        {
         ccIndex pos = tl->focused;
         TDskWin *obj = (TDskWin *)(edHelper->at(pos));

         switch( event.message.command )
           {
            case cmGo:
                 if (obj->GoAction(pos))
                    delete obj;
                 tl->setRange(edHelper->getCount());
                 break;

            case cmDelete:
                 if (obj->DeleteAction(pos))
                    delete obj;
                 tl->setRange(edHelper->getCount());
                 break;

            default:
                 return;
           }
         if (state & sfModal)
           {
            endModal(event.message.command);
            clearEvent(event);
           }
        }
         break;
   }
}

void BringListOfWindows(void)
{
 TRect r=TApplication::deskTop->getExtent();
 r.b.x-=10;
 r.b.y-=6;

 TListWindowsDiag *d=new TListWindowsDiag(r);

 focusChanged=False;
 int i;

 do
  {
   TProgram::deskTop->insert(d);
   d->setState(sfModal,True);
   i = d->execute();
   TProgram::deskTop->remove(d);
  }
 while (i==cmDelete);
 delete d;

 if (focusChanged)
   {
    setFocusTo->select();
    setFocusTo->show();
    TProgram::deskTop->unlock();
   }
}
