/*****************************************************************************
 *
 *  Exit routines, these routines are based on the Allegro routines.
 *
 *  Taked from Allegro without modifications.
 *
 *  SET	== Salvador Eduardo Tropea.
 *  Curapaligue	2124
 *  Caseros, Pdo. Tres de Febrero
 *  (1678) Buenos Aires
 *  Argentina.
 *
 *  e-mail: salvador@inti.edu.ar
 *
 *  Phone: +(541) 759 0013
 *
 *****************************************************************************
 *	   ______   ___	   ___
 *	  /\  _	 \ /\_ \  /\_ \
 *	  \ \ \L\ \\//\	\ \//\ \      __     __	  _ __	 ___
 *	   \ \	__ \ \ \ \  \ \	\   /'__`\ /'_ `\/\`'__\/ __`\
 *	    \ \	\/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *	     \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *	      \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/	\/___/
 *					     /\____/
 *					     \_/__/
 *	By Shawn Hargreaves,
 *	1 Salisbury Road,
 *	Market Drayton,
 *	Shropshire,
 *	England, TF9 1AJ.
 *
 *	Keyboard routines.
 *
 * Allegro is swap-ware. You may use, modify, redistribute, and	generally
 * hack	it about in any	way you	like, but if you do you	must send me
 * something in	exchange. This could be	a complimentary	copy of	a game,	an
 * addition or improvement to Allegro, a bug report, some money	(this is
 * particularly	encouraged if you use Allegro in a commercial product),	or
 * just	a copy of your autoexec.bat if you don't have anything better. If
 * you redistribute parts of Allegro or	make a game using it, it would be
 * nice	if you mentioned me somewhere in the credits, but if you just want
 * to pinch a few routines that	is OK too. I'll	trust you not to rip me	off.
 *
 */

// That's the first include because is used to configure the editor.
#include "ceditint.h"

#include <stdlib.h>

#define	MAX_EXIT_FUNCS	   8

/* we have to use a dynamic list rather	than calling all the cleanup
 * routines directly, so the linker won't end up including more	code than
 * is really required.
 */
typedef	void (*funcptr)(void);

static funcptr exit_funcs[MAX_EXIT_FUNCS] =
{
   NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
};

/* _add_exit_func:
 *  Adds a function to the list	that need to be	called by allegro_exit().
 */
void _add_exit_func(void (*func)())
{
   int c;

   for (c=0; c<MAX_EXIT_FUNCS; c++) {
      if (!exit_funcs[c]) {
	 exit_funcs[c] = func;
	 break;
      }
   }
}


/* _remove_exit_func:
 *  Removes a function from the	list that need to be called by allegro_exit().
 */
void _remove_exit_func(void (*func)())
{
   int c;

   for (c=0; c<MAX_EXIT_FUNCS; c++) {
      if (exit_funcs[c]	== func) {
	 exit_funcs[c] = NULL;
	 break;
      }
   }
}


/* allegro_exit:
 *  Closes down	the Allegro system. This includes restoring the	initial
 *  pallete and	video mode, and	removing whatever mouse, keyboard, and
 *  timer routines have	been installed.
 */
void allegro_exit()
{
   int c;

   for (c=0; c<MAX_EXIT_FUNCS; c++)
      if (exit_funcs[c])
	 (*exit_funcs[c])();
}
