/* system.h -- header for GNU gettext libiberty
   Copyright (C) 1995 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef _SYSTEM_H
#define _SYSTEM_H 1

#ifndef __P
# if __STDC__
#  define __P(args) args
# else
#  define __P(args) ()
# endif
#endif

#include <stdio.h>
#include <sys/types.h>

#if defined STDC_HEADERS
# include <stdlib.h>
#else
# ifdef HAVE_MALLOC_H
#  include <malloc.h>
# endif
unsigned long strtoul ();
#endif

/* Prototypes for helper functions.  */
extern char *get_submitter __P ((char *buffer));
extern FILE *open_po_file __P ((const char *input_name, char **file_name));

/* Wrapper functions with error checking for standard functions.  */
extern char *xgetcwd __P ((void));
extern void *xmalloc __P ((size_t __n));
extern void *xrealloc __P ((void *__p, size_t __n));
extern char *xstrdup __P ((const char *__string));
extern char *stpcpy __P ((char *__dst, const char *__src));
extern size_t parse_printf_format __P ((const char *__fmt, size_t __n,
					int *__argtypes));

#if STDC_HEADERS || HAVE_STRING_H
# include <string.h>
# if !STDC_HEADERS && HAVE_MEMORY_H
#  include <memory.h>
# endif
#else
# include <strings.h>
#endif
#if !HAVE_MEMCPY
# ifndef memcpy
#  define memcpy(D, S, N) bcopy ((S), (D), (N))
# endif
#endif
#if !HAVE_STRCHR
# ifndef strchr
#  define strchr index
# endif
#endif

#ifdef __GNUC__
# ifndef alloca
#  define alloca __builtin_alloca
# endif
#else
# if HAVE_ALLOCA_H
#  include <alloca.h>
# else
#  ifdef _AIX
 #pragma alloca
#  else
#   ifndef alloca
char *alloca ();
#   endif
#  endif
# endif
#endif

#ifndef MAX
# if __STDC__ && defined __GNUC__ && __GNUC__ >= 2
#  define MAX(a,b) (__extension__					    \
		     ({__typeof__ (a) _a = (a);				    \
		       __typeof__ (b) _b = (b);				    \
		       _a > _b ? _a : _b;				    \
		      }))
# else
#  define MAX(a,b) ((a) > (b) ? (a) : (b))
# endif
#endif

/* Some systems do not define EXIT_*, even with STDC_HEADERS.  */
#ifndef EXIT_SUCCESS
# define EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
# define EXIT_FAILURE 1
#endif

#endif
