/* acconfig.h -- autoheader configuration file

   This file is part of the LZO real-time data compression package.

   Copyright (C) 1997 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996 Markus Franz Xaver Johannes Oberhumer

   The LZO library and packer is free software; you can redistribute it
   and/or modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer
   markus.oberhumer@jk.uni-linz.ac.at
 */


#ifndef __LZOP_CONFIG_H
#define __LZOP_CONFIG_H

/* $TOP$ */
@TOP@

/* acconfig.h

   Descriptive text for the C preprocessor macros that
   the distributed Autoconf macros can define.
   No software package will use all of them; autoheader copies the ones
   your configure.in uses into your configuration header file templates.

   The entries are in sort -df order: alphabetical, case insensitive,
   ignoring punctuation (such as underscores).  Although this order
   can split up related entries, it makes it easier to check whether
   a given entry is in the file.

   Leave the following blank line there!!  Autoheader needs it.  */


/* Define to your architecture name.  */
#undef MFX_ARCH

/* Define if your compiler is broken.  */
#undef MFX_PROG_CC_BUG_SIGNED_TO_UNSIGNED_CASTING

/* Define to your CPU name.  */
#undef MFX_CPU

/* Define if your memcmp is broken.  */
#undef MFX_MEMCMP_BROKEN

/* Define to the name of the distribution.  */
#undef PACKAGE

/* Define to `long' if <stddef.h> doesn't define.  */
#undef ptrdiff_t

/* The number of bytes in a ptrdiff_t.  */
#undef SIZEOF_PTRDIFF_T

/* The number of bytes in a size_t.  */
#undef SIZEOF_SIZE_T

/* Define to the version of the distribution.  */
#undef VERSION



/* Leave that blank line there!!  Autoheader needs it.
   If you're adding to this file, keep in mind:
   The entries are in sort -df order: alphabetical, case insensitive,
   ignoring punctuation (such as underscores).  */



@BOTTOM@

/* $BOTTOM$ */

#if defined(HAVE_GMTIME) && !defined(TIME_WITH_SYS_TIME)
#  undef /**/ HAVE_GMTIME
#endif

#if defined(HAVE_LOCALTIME) && !defined(TIME_WITH_SYS_TIME)
#  undef /**/ HAVE_LOCALTIME
#endif

#if defined(HAVE_STRFTIME) && !defined(TIME_WITH_SYS_TIME)
#  undef /**/ HAVE_STRFTIME
#endif

#if defined(HAVE_SYS_RESOURCE_H) && !defined(TIME_WITH_SYS_TIME)
#  undef /**/ HAVE_SYS_RESOURCE_H
#endif

#if defined(HAVE_SYS_TIMES_H) && !defined(TIME_WITH_SYS_TIME)
#  undef /**/ HAVE_SYS_TIMES_H
#endif

#if (SIZEOF_PTRDIFF_T <= 0)
#  undef /**/ SIZEOF_PTRDIFF_T
#endif

#if (SIZEOF_SIZE_T <= 0)
#  undef /**/ SIZEOF_SIZE_T
#endif

#endif /* already included */

/*
vi:ts=4
*/
