/* Project SWORD
   V2.0

   SubSystem : Basic objects, General use mecanisms
   File      : Src/Mecanism/Atom.CC
   Author    : Eric NICOLAS
   Overview  : Object TAtom : Linked lists, Objets streams
   UpDate    : Oct 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Disk.H"
#include "Mecanism/Atom.H"

// Global variables

short  RegTAtom;
char  *IdentTAtom = "TAtom";

// Local variables

typedef TAtom* PAtom;

short  NbRegObjectsMax;
short  NbRegObjects;
PAtom* RegObjects;

// Constructor, Destructor

TAtom::TAtom(void)
{ _Next=_Previous=_Son=_Father=NULL;
  Register=RegTAtom;
  Ident=IdentTAtom;
  Destroyed=FALSE;
}

TAtom::~TAtom(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TAtom::Done(void)
{ UnLink();
  while(_Son!=NULL)
    delete _Son;
}

// Linked Lists

void TAtom::Link(TAtom* A)
{ TAtom* T;
  if (A!=NULL)
  { T=Last();
    T->_Next=A;
    A->_Previous=T;
  }
}

void TAtom::LinkBefore(TAtom* A)
{ TAtom *T;
  if (A!=NULL)
  { T=First();
    T->_Previous=A;
    A->_Next=T;
  }
}

void TAtom::UnLink(void)
{ if (_Father!=NULL)
    if (_Father->_Son==this) _Father->_Son=_Next;
  if (_Next!=NULL) _Next->_Previous=_Previous;
  if (_Previous!=NULL) _Previous->_Next=_Next;
  _Next=_Previous=_Father=NULL;
}

void TAtom::InsertBefore(TAtom* A)
{ if (A!=NULL)
  { A->_Father=this;
    if (_Son!=NULL) _Son->LinkBefore(A);
    _Son=A;
  }
}

void TAtom::Insert(TAtom* A)
{ if (A!=NULL)
  { A->_Father=this;
    if (_Son==NULL) _Son=A; else _Son->Link(A);
  }
}

TAtom* TAtom::First(void)
{ TAtom* A=this;
  while(A->_Previous!=NULL) A=A->_Previous;
  return A;
}

TAtom* TAtom::Last(void)
{ TAtom* A=this;
  while(A->_Next!=NULL) A=A->_Next;
  return A;
}

// Registration system (Objects streams)

TDisk *RegisterLog;

void InitRegister(void)
{ NbRegObjectsMax=10;
  NbRegObjects=0;
  RegObjects=new PAtom[NbRegObjectsMax];
  // Create Register Log file
  char FName[200];
  sprintf(FName,"%sREGISTER.LOG",SwordPath);
  RegisterLog=new TDisk(FName,stCreate);
  RegisterLog->WriteLn("SWORD Object Register");
  RegisterLog->WriteLn("");
}

void DoneRegister(void)
{ delete RegisterLog;
  delete RegObjects;
}

void RegisterObject(TAtom* A, short *Register)
{ if (NbRegObjects>=NbRegObjectsMax)
  { NbRegObjectsMax+=10;
    PAtom* Temp=new PAtom[NbRegObjectsMax];
    PAtom* ToFree;
    int    i;
    for(i=0;i<NbRegObjects;i++)
      Temp[i]=RegObjects[i];
    ToFree=RegObjects;
    RegObjects=Temp;
    delete ToFree;
  }
  RegObjects[NbRegObjects]=A;
  A->Register=*Register=NbRegObjects;
  NbRegObjects++;
  // Infos vers le fichier Register.LOG
  char Info[200];
  sprintf(Info,"%04X - %s",A->Register,A->Ident);
  RegisterLog->WriteLn(Info);
}

void TAtom::Read(TDisk *file)
{ long   NbSons;
  int    i;
  // Read Nb of sons
  file->Read(&NbSons,sizeof(long));
  // Read all sons
  for(i=0;i<NbSons;i++) Insert(ReadObject(file));
}

void TAtom::Write(TDisk *file)
{ long   NbSons;
  TAtom *A;
  // Write what object it is
  file->Write(&Register,sizeof(short));
  // How sons are they ?
  NbSons=0;
  A=_Son;
  while(A!=NULL)
  { NbSons++;
    A=A->_Next;
  }
  // Write Nb of sons
  file->Write(&NbSons,sizeof(long));
  // Write all sons
  A=_Son;
  while(A!=NULL)
  { A->Write(file);
    A=A->_Next;
  }
}

TAtom *ReadObject(TDisk *file)
{ short  Reg;
  TAtom *A;
  file->Read(&Reg,sizeof(short));
  A=RegObjects[Reg]->Duplicate();
  A->Read(file);
  return A;
}

void WriteObject(TDisk *file, TAtom *A)
{ A->Write(file);
}

void ReadString(TDisk *file, char **Text)
{ short C;
  file->Read(&C,sizeof(short));
  if (C==0)
  { *Text=NULL;
  }
  else
  { *Text=(char*)malloc(C+1);
    file->Read(*Text,C);
    *(*Text+C)=0;
  }
}

void WriteString(TDisk *file, char *Text)
{ short C;
  if (Text==NULL)
  { C=0;
    file->Write(&C,sizeof(short));
  }
  else
  { C=strlen(Text);
    file->Write(&C,sizeof(short));
    file->Write(Text,C);
  }
}

void ReadInt(TDisk *file, int *Value)
{
#ifdef __TURBOC__
  long Temp;
  file->Read(&Temp,sizeof(long));
  *Value=Temp;
#else
  file->Read(Value,sizeof(int));
#endif
}

void WriteInt(TDisk *file, int Value)
{
#ifdef __TURBOC__
  long Temp=Value;
  file->Write(&Temp,sizeof(long));
#else
  file->Write(&Value,sizeof(int));
#endif
}
