## Project SWORD
#  V2.0
#
#  File      : Samples/Makefile.INC
#  Author    : Eric NICOLAS
#  Overview  : Automatic Makefile for Executables projects
#  UpDate    : Nov 20, 1995
#
## Copyright (C) 1993,1995 The SWORD Group
##
## This file is distributed under the terms listed in the document
## "copying.en". A copy of "copying.en" should accompany this file.
## if not, a copy should be available from where this file was obtained.
## This file may not be distributed without a verbatim copy of "copying.en".
##
## This file is distributed WITHOUT ANY WARRANTY; without even the implied
## warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

#
# Implicit Rules
#

%.o: %.cc
	gcc -c -O -I$(INCLUDE) $< -o $@

%.d: %.cc
	gcc -E -MMD -I$(INCLUDE) $< -o $@

#
# Auto-Targets
#

OBJECTS  = $(SOURCES:.cc=.o)
DEPENDS  = $(SOURCES:.cc=.d)
OUT      = $(DEST:.exe=.out)
LIBRARY  = $(LIB)/libSWORD.a

#
# Other Options
#

ARCHIVES = -lSword -ljpeg2 -ljpeg -lgrx -lqueue -lpc

#
# Build destination executable
#

default: $(DEST)

depend: $(DEPENDS)
	- copy *.d depend.inc

clean:
	- del *.o
	- del *.d
	- del *.bak

all: clean depend default

$(DEST): $(OBJECTS) $(LIBRARY)
	gcc $(OBJECTS) -L$(LIB) $(ARCHIVES) -o $(OUT)
	strip $(OUT)
	coff2exe $(OUT)
	- del $(OUT)

debug: $(OBJECTS)
	gcc $(OBJECTS) -L$(LIB) $(ARCHIVES) -o $(OUT)

#
# Dependencies
#

include depend.inc