/* Project SWORD
   V2.0

   SubSystem : Image manipulation tools
   File      : Include/ToolBox/Image/ImgView.H
   Author    : Eric NICOLAS
   Overview  : TImageScroller, TImageViewer Object : Voir des images
   UpDate    : Nov 12, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _TOOLBOX_IMAGE_IMGVIEW_H_
#define _TOOLBOX_IMAGE_IMGVIEW_H_

// --- TImageScroller Object

extern short RegTImageScroller;
extern char *IdentTImageScroller;

struct TImageScroller : TScroller
{ protected:
    TImageFile *ImageFile;
  public:
  // Constructor / Destructor
          TImageScroller();
          TImageScroller(TRect& R, TImageFile *IF, TLift *H, TLift *V);
          void     Init(TImageFile *IF);
  // Drawing Funcs
  virtual void     Draw(TRect &Clip);
  // Objects streams
  virtual TAtom*   Duplicate(void);
};


// --- TImageViewer Object

extern short RegTImageViewer;
extern char *IdentTImageViewer;

struct TImageViewer : TStdWindow
{ protected:
    TImageFile *ImageFile;
  public:
  // Constructor / Destructor
          TImageViewer();
          TImageViewer(int X, int Y, int L, int H, char *FileName);
          TImageViewer(TRect& R, char *FileName);
          void     Init(char *FileName);
  virtual ~TImageViewer(void);
  // Objects streams
  virtual TAtom*   Duplicate(void);
};

// Inline functions

inline TAtom* TImageScroller::Duplicate(void)
{ return new TImageScroller();
}

inline TAtom* TImageViewer::Duplicate(void)
{ return new TImageViewer();
}

#endif // _TOOLBOX_IMAGE_IMGVIEW_H_