/* Project SWORD
   V2.0

   SubSystem  : Screen graphics management
   CommandNos : 2100..2199
   File       : Include/Graphics/Shell.H
   Author     : Eric NICOLAS
   Overview   : Basic object : creation of events, mouse management, ScreenSaver
   UpDate     : Oct 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GRAPHICS_SHELL_H_
#define _GRAPHICS_SHELL_H_

// Defines

#define mbLeft   0x0001
#define mbRight  0x0002
#define mbMiddle 0x0004

#define MaxEventStock 50

#define cmDrawCursor   2100
#define cmReDrawScreen 2101
#define cmUpdateMouse  2102

// Objet TShell

extern short RegTShell;
extern char *IdentTShell;

struct TShell : TObject
{ TEvent EventStock[MaxEventStock];
  int    NbEventStock;
  // Constructor / Destructor
          TShell(void);
  virtual ~TShell(void);
  // Selections
  virtual boolean  Focus(void);
  // Events
          void     GetKeyMouseEvent(TEvent *Event);
          void     GetTimeEvent(TEvent *Event);
  virtual void     GetEvent(TEvent *Event);
  virtual boolean  ToggleKey();
  virtual void     SetEvent(TEvent *Event);
  virtual void     HandleEvent(TEvent *Event);
  virtual boolean  HandleCommand(long Command, char Info08b=0, short Info16b=0, long Info32b=0, void *InfoPtr=NULL);
          long     EventsLoop(TObject *O);
};

// Object Screen Saver

struct TScreenSaver
{ // Datas
  TShell *TheShell;
  int     NoStep;
  long    MouseChangeTime;
  // Constructor
  TScreenSaver(TShell *Shell);
  // Standard actions
  boolean NoUserAction(void);
  void Execute(void);
  // Actions to override
  virtual void Init(void);
  virtual void Step(void);
  virtual void Done(void);
};

extern TScreenSaver *ScreenSaver;
extern long          ScreenSaverDelay;   // Inactivity delay before Screen
                                         // saver ON (in seconds)

// Usefull functions

void SetAlarm(long Comm, long Delay, void *Ptr); // Delay in 1/100 s

#endif // _GRAPHICS_SHELL_H_
