#include <stdio.h>
#include <stdlib.h>
#include <help.h>

HelpID help_id = NULL;
int ntabs = 0;
char **tabs = NULL;
char **topics = NULL;

#define OK      0
#define ERROR   1

void helpcallback(void *arg)
{
    /* Check for Expose or ConfigureNotify events */
    /* If any available, process them, update screen etc */
}

int initialize_prog()
{
    int rc;
    char *display_name;

    if ((rc = Help_initialize(NULL,"Example Help File","EXAMPLE.HLP",
        30,15,helpcallback,(void *)0,&help_id)) != H_OK) {
        fprintf(stdout,"Error initializing help (%d)\n",rc);
        return(ERROR);
    }
    if ((rc = Help_get_sections(help_id,&ntabs,&tabs,&topics)) != H_OK) {
        fprintf(stdout,"Error getting sections (%d)\n",rc);
        return(ERROR);
    }
    return(OK);
}

int terminate_prog()
{
    int i,rc;

    if (help_id != NULL) {
        if ((rc = Help_terminate(help_id)) != H_OK) {
            fprintf(stdout,"Error terminating help (%d)\n",rc);
            return(ERROR);
        }
        help_id = NULL;
    }
    if (tabs != NULL) {
        for (i = 0; i < ntabs; i++) {
            free(tabs[i]);
            free(topics[i]);
        }
        free(tabs);
        free(topics);
        tabs = NULL;
        topics = NULL;
    }
    return(OK);
}


void main (int argc, char **argv)
{
    int section,rc,done,selection;

    if (initialize_prog() != OK) {
        terminate_prog();
        exit(-1);
    }

    /* main loop */
    done = 0;

    while (!done) {

      fprintf(stdout,"\n");
      for(section = 0; section < ntabs ; section ++)
          fprintf(stdout,"Section %d: %s\n",section+1,tabs[section]);

      while (1) {
        fprintf(stdout,"\nEnter section number to show or 0 to quit: ");
        if (fscanf(stdin,"%d",&selection) == 1) {
          if (selection == 0) {
            done = 1;
            break;
            }
          section = selection - 1;
          if (section < ntabs) {
            rc = Help_show(help_id,topics[section]);
            if (rc != H_OK)
               fprintf(stdout,"Error Help_show (%d)\n",rc);
            break;
            }
          }
        }
      }

    terminate_prog();
}
