/**********************************************************************
 *  
 *  NAME:           window.h
 *  
 *  DESCRIPTION:    basic window with attribute mapping:
 *                  this is what an app should use, NOT basewin
 *  
 *  copyright (c) 1990 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  12/??/90    J. Alan Eldridge    created
 *  
 *  12/25/90    JAE                 added interface to winlist.cpp, which
 *                                  keeps a front-to-back list of windows
 *
 *********************************************************************/

#ifndef __WINDOW_H
#define __WINDOW_H

class Window;

extern Window   *findwin(int &y, int &x);

#define MAXWNAME    33

class Window:
    public  basewin,
    public  attribmap {

private:

    uchar   name [ MAXWNAME ];   //  name of window (later ...)
    uchar   att;    //  the logical video attribute

    vidbuf  save;   //  to save screen before popup
    
    void    newtop();
protected:
    //  let a Window highlight itself according to 
    //  whether it's on top of the list or not ...
    virtual void    activate()
        { touchall(); }
    virtual void    deactivate()
        { }
    
public:

    virtual char   *isA()
        { return "Window"; }
        
    void    setname(uchar *s);

    uchar   *getname()
        { return name; }
                
    //  constructor
    Window(int yul, int xul, int ylr, int xlr, uchar *name = 0);
        
    //  destructor
    virtual ~Window()
        { unlink(); }
        
    //  position on window list
    int     istop();                    //  is it the front window?
    int     maketop(int show = TRUE);   //  bring window to front of list
    void    unlink();                   //  remove from list
    
    //  video attribute control
    virtual void    setattr(uchar a)
        { att = a; basewin::setattr(getmap(a)); }
    virtual int     getattr()
        { return att; }

    //  save, restore screen image (for popups)
    int     savescreen();
    void    restorescreen(int closeit = FALSE);

};

#endif
