/*
    sysqvfnc.cpp

    queues of objects of type Qable
    
    copyright (c) 1991 J. Alan Eldridge
    
    history:
    
    < from sysqtmpl.h -- the template version >

    10/28/91    created
    
    10/30/91    changed class hierarchy so we now have:
    
                SysQ<T>     queue of Ts
                SysPriQ<T>  priority queue of Ts
                SysQP<T>    queue of ptrs to T
                SysPriQP<T> priority queue of ptrs to T

    11/08/91    created this virtual function version...
                this has only classes SysQP and SysPriQP
*/

#include    "aedef.h"
#include    "sysqvfnc.h"

SysQP::SysQP(int n, int lim)
{
    nused = nfree = 0;
    maxnodes = lim;
    head = tail = free = 0;
    while (n-- > 0)
        putfree(new SysQNode);
}

SysQP::~SysQP()
{
    Qable       *t;
    SysQNode    *pn;
    
    //  dump all nodes onto free list
    while (Get(t))
        ;
    //  delete all nodes on free list
    while ((pn = getfree(0)) != 0)
        delete pn;
}

SysQNode*
SysQP::getfree(int alloc)
{
    SysQNode      *pn = 0;

    if (nfree > 0) {
        pn = free;
        free = free->next;
        nfree--;
    } else if (alloc) {
        pn = new SysQNode;
    }
    
    return pn;
}

void
SysQP::putfree(SysQNode *pn)
{
    nfree++;
    pn->next = free;
    free = pn;
}

SysQNode*
SysQP::findnode(Qable *t)
{
    SysQNode    *pn = head;
    
    while (pn && !(pn->data == t))
        pn = pn->next;
    
    return pn;
}

void
SysQP::create(SysQNode *pn)
{
    head = tail = pn;
    nused = 1;
    pn->prev = pn->next = 0;
}

void
SysQP::insert(SysQNode *pnext, SysQNode *pn)
{
    //  add before 0 means put at tail

    if (!nused)
        create(pn);
    else {
        if (pnext) {
            pn->prev = pnext->prev;
            if (pnext == head)
                head = pn;
            else
                pnext->prev->next = pn;
            pnext->prev = pn;
            pn->next = pnext;
        } else {
            pn->prev = tail;
            tail->next = pn;
            tail = pn;
            pn->next = 0;
        }
        nused++;
    }
}
        
int
SysQP::Add(Qable *t)
{
    SysQNode    *pn = getfree(nused + nfree < maxnodes);
    
    if (pn) {
        pn->data = t;
        insert(0, pn);
    }

    return !!pn;
}

SysQNode*
SysQP::findpred(Qable *t)
{
    SysQNode    *pwalk;
    
    pwalk = head;
    while (pwalk && !(pwalk->data[0] < t[0]))
        pwalk = pwalk->next;
    return pwalk;
}
        
int
SysQP::Ins(Qable *t)
{
    SysQNode    *pn = getfree(nused + nfree < maxnodes);

    if (pn) {
        pn->data = t;
        insert(findpred(t), pn);
    }
    
    return !!pn;
}

int
SysQP::Get(Qable* &t, int rmv)
{
    SysQNode    *pn = head;
    
    if (pn) {
        t = head->data;
        if (rmv) {
            if ((head = head->next) != 0)
                head->prev = 0;
            else
                tail = 0;
            nused--;
            putfree(pn);
        }
    }
    
    return !!pn;
}

int
SysQP::Del(Qable *t)
{
    SysQNode    *pn = findnode(t);
    
    if (pn) {
        if (nused == 1)
            head = tail = 0;
        else if (pn == head) 
            (head = head->next)->prev = 0;
        else if (pn == tail)
            (tail = tail->prev)->next = 0;
        else {
            pn->next->prev = pn->prev;
            pn->prev->next = pn->next;
        }
        nused--;
        putfree(pn);
    }
    
    return !!pn;
}

Qable *
SysQP::Get(int rmv)
{
    Qable *pq;
    
    return Get(pq,rmv) ? pq : 0;
}
