/*----------------------------------------------------------------------
 *
 *  printw.c
 *
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  the printf() type functions for Curses
 *
 *----------------------------------------------------------------------
 */

#include "curses.h"

#include <stdarg.h>

int
printw(char *fmt, ...)
{
    va_list ap;
    char    buf[512];
    
    va_start(ap, fmt);
    vsprintf(buf, fmt, ap);
    va_end(ap);
    
    return addstr(buf);
}

int
mvprintw(int r, int c, char *fmt, ...)
{
    va_list ap;
    char    buf[512];

    va_start(ap, fmt);
    vsprintf(buf, fmt, ap);
    va_end(ap);

    move(r, c);
    return addstr(buf);
}

int 
wprintw(WINDOW *win, char *fmt, ...)
{
    va_list ap;
    char    buf[512];

    va_start(ap, fmt);
    vsprintf(buf, fmt, ap);
    va_end(ap);

    return waddstr(win, buf);
}

int 
mvwprintw(WINDOW *win, int r, int c, char *fmt, ...)
{
    va_list ap;
    char    buf[512];

    va_start(ap, fmt);
    vsprintf(buf, fmt, ap);
    va_end(ap);

    wmove(win, r, c);
    return waddstr(win, buf);
}

