/**********************************************************************
 *  
 *  curses.pro
 *  
 *  copyright (c) 1989,90 J. Alan Eldridge
 *
 *  function prototypes for Curses! 3.X
 *  
 *********************************************************************/

#ifndef __CURSES_PRO__
#define __CURSES_PRO__

#include "curses.h"

#ifndef NO_PROTO

#ifdef __cplusplus
extern "C" {
#endif

/* alert.c */

int alertf(
    int     die,
    char    *title,
    char    *prompt,
    int     *keys,
    int     sound,
    char    *fmt,
    ...);

void alertattr(int att);

int alerts(
    int     die,
    char    *title,
    char    *prompt,
    int     *keys,
    int     sound,
    char *s);

void init_alerts(void);

/* viewfile.c */

int view_file(
    FILE    *fp,
    WINDOW  *win,
    char    *title);

/* boxwin.c */

int boxwin(
    WINDOW  *wptrs[2],
    int     lines,
    int     cols,
    int     orgy,
    int     orgx,
    int     v,
    int h);

/* cornerch.c */

int cornerchar(
    int n,
    int v,
    int h);

/* drawbox.c */

int drawbox(
    WINDOW  *win,
    int     lines,
    int     cols,
    int     v,
    int     h);

/* expldwin.c */

int expldwin(
    WINDOW  *wptrs[2],
    int     l,
    int     c,
    int     y,
    int     x,
    int     v,
    int     h);

/* line.c */

int linechar(
    int h_or_v,
    int n);

void whline(
    WINDOW  *win,
    int     n,
    int     len);

void wvline(
    WINDOW  *win,
    int     n,
    int     len);

/* mvwin.c */

int mvwin(
    WINDOW  *win,
    int     y,
    int     x);

/* pm_obj.c */

int pm_ctor(
    POPUP_MENU  *this,
    int         id,
    int         y,
    int         x,
    char        *title,
    int         maxr,
    char        **arr,
    int         norm,
    int         high);

void pm_dtor(POPUP_MENU *this);

int scrollmsize(
    char    *title,
    int     maxr,
    char    **arr,
    int     *rp,
    int     *cp,
    int     *scrollp);

int popmsize(
    char    *title,
    char    **arr,
    int     *rp,
    int     *cp);

void pm_draw(POPUP_MENU *this);

void pm_smooth(int flag);

void pm_next(
    POPUP_MENU  *this,
    int         redraw_flag);

void pm_prev(
    POPUP_MENU  *this,
    int         redraw_flag);

int pm_choose(POPUP_MENU *this);

int pm_select(
    POPUP_MENU  *this,
    int         item_num);

char **pm_itemlist(POPUP_MENU *this);

int pm_id(POPUP_MENU *this);

/* popmenu.c */

void init_popmenus(void);

void popmenuattr(
    int n, 
    int h);

int scrollmenul(
    int     orgy, 
    int     orgx, 
    char    *title, 
    int     maxrows);

int popmenul(
    int     orgy, 
    int     orgx, 
    char    *title);

int scrollmenuv(
    int     orgy, 
    int     orgx, 
    char    *title, 
    int     maxrows, 
    char    **array);

int popmenuv(
    int     orgy, 
    int     orgx, 
    char    *title, 
    char    **array);

/* box.c */

int box(
    WINDOW  *win,
    int     v,
    int     h);

/* calcpopy.c */

int calcpopyx(
    int rows,
    int cols,
    int cury,
    int minx,
    int maxx,
    int *yp,
    int *xp);

/* savescr.c */

WINDOW *savescr(
    int r,
    int c,
    int y,
    int x);

void restscr(WINDOW *win);

/* overlay.c */

int overlay(
    WINDOW  *win1,
    WINDOW  *win2);

int overwrite(
    WINDOW  *win1,
    WINDOW  *win2);

/* spooler.c */

int setspoolpri(int pri);
int getspoolpri(void);
int spoolqsize(void);
int setspoolbuf(int bufsize);
int spool(char *fn);

int initspooler(
    int pri,
    int bufsiz);

void spoolabort(void);
void spoolflush(void);

/* teechar.c */

int teechar(
    int pos,
    int v,
    int h);

/* wcentstr.c */

int wcentstr(
    WINDOW  *win,
    int     row,
    char    *str);

/* wdelch.c */

int wdelch(WINDOW *win);

/* werase.c */

int werase(WINDOW *win);
int wclear(WINDOW *win);

/* wgetstr.c */

int weditstr(
    WINDOW  *win,
    char    *buf,
    int     cnt);

int wgetstr(
    WINDOW  *win,
    char    *buf);

int wegetstr(
    WINDOW  *win,
    char    *buf);

int weditfld(
    WINDOW  *win,
    char    *buf,
    int     len,
    int     *term,
    int     ins,
    int     skip,
    int     fix,
    int     zap);
    
int wedittxt(
    WINDOW  *win,
    char    *buf,
    int     len,
    int     *term,
    int     ins,
    int     skip,
    int     fix,
    int     zap,
    int     (*filter)());

/* matchkey.c */

int kb_matchkey(
    int *arr,
    int val);

/* printw.c */

int printw(
    char    *fmt,
    ...);

int mvprintw(
    int     r,
    int     c,
    char    *fmt,
    ...);

int wprintw(
    WINDOW  *win,
    char    *fmt,
    ...);

int mvwprintw(
    WINDOW  *win,
    int     r,
    int     c,
    char    *fmt,
    ...);

/* waddstr.c */

int waddstr(
    WINDOW  *win,
    char    *str);

/* winflags.c */

void scrollok(
    WINDOW  *win,
    int     ok);

void leaveok(
    WINDOW  *win,
    int     ok);

void clearok(
    WINDOW  *win,
    int     ok);

void wrapok(
    WINDOW  *win,
    int     ok);

/* winsch.c */

int winsch(
    WINDOW  *win,
    int     ch);
        
/* wclrtoeo.c */

int wclrtoeol(WINDOW *win);
int wclrtobot(WINDOW *win);

/* scroll.c */

int _scroll(
    WINDOW  *win,
    int     start_line,
    int     end_line,
    int     lines);

/* curses.c */

void set_machine_id(MACHINE_ID *id_ptr);
int echo(void);
int noecho(void);
int raw(void);
int noraw(void);
int crmode(void);
int nocrmode(void);
int nl(void);
int nonl(void);
int wgetch(WINDOW *win);

int waddch(
    WINDOW  *win,
    int     ch);

int wmove(
    WINDOW  *win,
    int     r,
    int     c);

int initscr(void);
int endwin(void);

/* curstype.c */

void blkcursor(void);
void undcursor(void);

/* delwin.c */

int delwin(WINDOW *win);

/* kbbgtask.c */

int getbgpri(int id);

int setbgpri(
    int id,
    int pri);

int addbgtask(
    void    (*func)(),
    int     pri);

int rmvbgtask(int id);
int kbgetc(void);

/* newwin.c */

WINDOW *newwin(
    int r,
    int c,
    int y,
    int x);

WINDOW *subwin(
    WINDOW  *win,
    int     r,
    int     c,
    int     y,
    int     x);

/* wrefresh.c */

int wrefresh(WINDOW *win);

/* markwin.c */

void markwin(WINDOW *win);
void umarkwin(WINDOW *win);
void touchwin(WINDOW *win);

/* machine.c */

void get_machine_id(MACHINE_ID *id_ptr);

/* ckbbios.c */

void _kb_init(void);
int _kb_read(void);
int _kb_look(void);

int _kb_syn(
    int oldval,
    int newval);

int _kb_mapc(int c);
int _kb_getc(void);

/* cmemsetw.c */

void memsetw(
    void far    *buf,
    void        *valp,
    int         wcnt);

/* cvidintf.c */

void vid_mov_curs(
    int y,
    int x);

void hidecursor(void);
void showcursor(void);

void sizecursor(
    int start_line,
    int end_line);

int vid_get_mode(void);

long vid_buf_addr(int mode);

void vid_get_curs_info(
    void    *posn,
    void    *size);

void vid_set_curs_info(
    void    *posn,
    void    *size);

void vid_save_scr(VID_SCR_BUFF *buffp);
void vid_rest_scr(VID_SCR_BUFF *buffp);
void vid_clr_scr(int attrib);

void vid_upd_scr(
    int     row,
    int     col,
    VIDCHR  *src,
    int     cnt);

#else   /* user said NO_PROTO */

char    **pm_itemlist();
WINDOW  *newwin();
WINDOW  *subwin();
WINDOW  *savescr();
void    *memsetw();
void    *memsrchw();
long    vid_buf_addr();

#ifdef __cplusplus
}
#endif

#endif  /* NO_PROTO */

#endif  /* __CURSES_PRO__ */


