        title   async TSR
        name    asynctsr
        page    ,132

BUFSIZE			= 4096

cseg    segment byte public 'code'
        assume cs:cseg
        org     100h
        .286

start:
        jmp     init

buffer_end      equ     buffer_start+BUFSIZE

        org     104h
isr:
        jmp     short isr_handler
        dw      'AT'                    ; signature
        dw      1                       ; header version
bbeg    dw      offset buffer_start
bend    dw      offset buffer_start
getp    dw      offset buffer_start
putp    dw      offset buffer_start
iov     dw      0
count   dw      0
over    dw      0
bsize   dw      BUFSIZE
flush   dw      1

isr_handler:
        pusha
        mov     al,20h
        out     20h,al
isr_top:
        mov     dx,iov
        add     dx,2
        in      al,dx
        cmp     al,1
        je      isr_exit
        cmp     al,4
        je      isr_rcv
        cmp     al,0
        je      isr_msr
        cmp     al,6
        je      isr_lsr
        jmp     isr_top

isr_msr:
        mov     dx,iov
        add     dx,6
        in      al,dx
        jmp     isr_top

isr_lsr:
        mov     dx,iov
        add     dx,5
        in      al,dx
        jmp     isr_top

isr_rcv:
        mov     dx,iov
        in      al,dx
        mov     bx,putp
        mov     cx,count
        ; check for & handle buffer overflow <jae>
        cmp     cx,bsize
        jb      isr_addch       ; count < bsize ==> ok
        inc     over            ; count the overflow
isr_ckflush:
        cmp     flush,0
        jg      isr_flush
        dec     cx              ; dec count (in cx) 
        dec     bx              ; back up putp (in bx)
        cmp     bx,offset buffer_start  ; fell off start of buffer?
        jge     isr_addch               ; no, go ahead
        mov     bx,bend                 ; yes, wrap to end of buffer - 1
        dec     bx
        jmp     isr_addch
isr_flush:
	xor	cx, cx
        ; end of overflow handling <jae>
isr_addch:
        inc     cx              ; count new char
        mov     cs:[bx],al      ; save it at putp
        inc     bx              ; inc putp
        cmp     bx,bend         ; fell off end of buffer?
        jb      isr_noend       ; no, go ahead
        mov     bx,offset buffer_start  ; yes, wrap to start of buffer
isr_noend:
        mov     putp,bx         ; save off new putp
        mov     count,cx        ; save off new count
        jmp     isr_top

isr_exit:
        popa
        iret
        
buffer_start    label   byte    ; last before init

;----------------------------------------------------------------------

err1    db      'Usage: asynctsr 1|2 [-][nnnn]',13,10
        db      '    -      no-flush-on-overflow flag (opt)',13,10
        db      '    nnnn   receive buffer size (opt,default=4096)'
        db      13,10,'$'

init:
        mov     al,ds:[82h]
        cmp     al,'1'
        je      init_1
        cmp     al,'2'
        je      init_2
cmderr:
        mov     dx,offset err1
        mov     ah,9
        int     21h
        mov     ax,4c01h
        int     21h

init_1:
        call    parse
        mov     iov,3f8h
        mov     bx,0ch*4
        mov     cl,0efh
        jmp     init_keep

init_2:
        call    parse
        mov     iov,2f8h
        mov     bx,0bh*4
        mov     cl,0f7h

init_keep:
        mov     ax,0
        mov     es,ax
        cli
        mov     word ptr es:[bx],offset isr
        mov     word ptr es:[bx+2],cs
        sti

        in      al,21h
        and     al,cl
        out     21h,al
        
        mov     dx,iov
        add     dx,1
        mov     al,0fh
        out     dx,al
        add     dx,3
        mov     al,0bh
        out     dx,al

        mov     dx,offset msg1
        mov     ah,9
        int     21h
        mov     dx,offset buffer_start
        add     dx,[bsize]
        mov     [bend], dx
        int     27h

msg1    db      'asynctsr installed', 13, 10, '$'

parse:  ; parse the buffer size from the command line
        mov     cl, ds:[80h];
        cmp     cl, 3
        jl      endparse
        mov     si, 83h
        lodsb   
        cmp     al,' '
        jne     errparse
        mov     al,[si]
        cmp     al,'-'
        jne     goparse
        mov     flush,0
        dec     cl
        inc     si
goparse:
        sub     cl, 3
        je      endparse
        xor     dx, dx
        xor     bh, bh
        xor     ax, ax
        mov     di, 10
get1:
        mov     bl,ds:[si]
        inc     si
        dec     cl
        cmp     bl,'0'
        jl      errparse
        cmp     bl,'9'
        jg      errparse
        sub     bl,'0'
        imul    di
        add     ax,bx
        cmp     cl, 0
        jg      get1
setsize:        
        or      ax,ax
        je      endparse
        mov     bsize,ax
endparse:
        ret

errparse:
        jmp     cmderr

cseg    ends
        end     start

