/* This is file EXTDEBUG.H */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _EXTDEBUG_H_
#define _EXTDEBUG_H_

/* This file defines the interface that go32 exports to external debuggers */

typedef struct {
  word16 version;	/* set to version number of interface */
  word16 a_tss_ofs;	/* pointer to TSS for debugged program */
  word16 a_tss_seg;
  word16 filename_ofs;	/* points to name of file being debugged */
  word16 filename_seg;
  word16 filename_len;
  word16 areas_ofs;	/* from paging.c */
  word16 areas_seg;
  /* 4-byte align required here */
  word32 app_base;	/* linear base address of application */
  word32 dr[8];		/* debug registers, set when a_tss runs */
  
  word32 ansi_mode;	/* if set, OK to emit ansi control codes */
} ExternalDebuggerInfo;

#define EXTERNAL_DEBUGGER_VERSION	1	/* this is version 1 */

/* These codes are passed in %al when %ah == 0xfe for int 0x21 */
#define EXTERNAL_DEBUGGER_EXECUTE	0	/* runs a_tss until stop */
#define EXTERNAL_DEBUGGER_GETINFOPTR	1	/* returns seg:ofs of info struct in edx:eax */


#ifndef __GO32__	/* These are internal to go32 */

extern int using_external_debugger;
extern void load_external_debugger(char *filename, char *running_fname, char *argv0);
extern int external_debugger_handler(void);

extern word16 external_debugger_cs;
extern word16 external_debugger_ds;

void set_break_DPMI(void);
void clear_break_DPMI(void);

#endif

#endif
