; This is file DPMISIM.ASM
;
; Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
;
; This file is distributed under the terms listed in the document
; "copying.dj", available from DJ Delorie at the address above.
; A copy of "copying.dj" should accompany this file; if not, a copy
; should be available from where this file was obtained.  This file
; may not be distributed without a verbatim copy of "copying.dj".
;
; This file is distributed WITHOUT ANY WARRANTY; without even the implied
; warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;

	title	dpmisim
	.386p

	include	segdefs.inc
	include tss.inc
	include gdt.inc
	include idt.inc

;------------------------------------------------------------------------

	start_data16

	extrn	_r_tss:tss_s
	extrn	_arena_cs:word
	extrn	_arena_ds:word
	extrn	_core_selector:word
	extrn	_tss_ptr:word
	extrn	_ARENA:dword

	public	_dpmisim_type
_dpmisim_type	db	0

	public	_dpmisim_vec
_dpmisim_vec	db	0

	public	_dpmisim_regs
_dpmisim_regs	label	dword
ds_edi	dd	?
ds_esi	dd	?
ds_ebp	dd	?
ds_res	dd	?
ds_ebx	dd	?
ds_edx	dd	?
ds_ecx	dd	?
ds_eax	dd	?
ds_flg	dw	?
ds_es	dw	?
ds_ds	dw	?
ds_fs	dw	?
ds_gs	dw	?
ds_ip	dw	?
ds_cs	dw	?
ds_sp	dw	?
ds_ss	dw	?

	public	_dpmisim_rmcb
_dpmisim_rmcb	dd	32 dup(?)

	dd	128 dup (?)
rmcb_temp_stack32	label	dword
	dd	offset rmcb_task_switch
	dw	g_rcode

	dw	128 dup (?)
rmcb_temp_stack16	label	word

	end_data16

;------------------------------------------------------------------------

	start_code16

	extrn	_memput:near
	extrn	_memget:near
	extrn	_go_til_stop:near

ds_savesp	dw	?
ds_savess	dw	?
ds_tmpds	dw	?

	public	_dpmisim
_dpmisim:

	pusha
	push	es

	mov	cs:[ds_savesp], sp
	mov	cs:[ds_savess], ss

	mov	ax,ds_flg
	and	ax,0fcffh
	push	ax
	popf

	mov	edi, ds_edi
	mov	esi, ds_esi
	mov	ebp, ds_ebp
	mov	ebx, ds_ebx
	mov	edx, ds_edx
	mov	ecx, ds_ecx
	mov	eax, ds_eax
	mov	es, ds_es
	mov	fs, ds_fs
	mov	gs, ds_gs
	mov	ss, ds_ss
	mov	sp, ds_sp

	push	cs
	push	offset dpmisim_return
	push	ds_cs
	push	ds_ip
	mov	ds, ds_ds
	retf	; actually a far call in disguise
dpmisim_return:

	mov	cs:[ds_tmpds], ds
	push	DGROUP
	pop	ds
	pushf
	pop	ds_flg

	mov	ds_edi, edi
	mov	ds_esi, esi
	mov	ds_ebp, ebp
	mov	ds_ebx, ebx
	mov	ds_edx, edx
	mov	ds_ecx, ecx
	mov	ds_eax, eax
	mov	ds_es, es
	mov	ds_fs, fs
	mov	ds_gs, gs
	mov	ds_ss, ss
	mov	ds_sp, sp
	
	mov	ax, cs:[ds_tmpds]
	mov	ds_ds, ax

	mov	ss, cs:[ds_savess]
	mov	sp, cs:[ds_savesp]

	pop	es
	popa
	ret

rmcb_number	db	?

rmcb	macro	n
	mov	cs:[rmcb_number],n
	jmp	short rmcb_common
	endm

	public	_dpmisim_rmcb0
_dpmisim_rmcb0:
	rmcb	0
	public	_dpmisim_rmcb1
_dpmisim_rmcb1:
	x=1
	rept 15
	 rmcb x
	 x=x+1
	endm

rmcb_common:
	mov	cs:[ds_tmpds], ds
	push	DGROUP
	pop	ds
	pushf
	pop	ds_flg

	mov	ds_edi, edi		; save registers
	mov	ds_esi, esi
	mov	ds_ebp, ebp
	mov	ds_ebx, ebx
	mov	ds_edx, edx
	mov	ds_ecx, ecx
	mov	ds_eax, eax
	mov	ds_es, es
	mov	ds_fs, fs
	mov	ds_gs, gs
	mov	ds_ss, ss
	mov	ds_sp, sp

	mov	ax,cs:[ds_tmpds]
	mov	ds_ds, ax		; move DS to proper location

	mov	ax,ds			; set up our local stack
	mov	ss,ax
	mov	sp, offset rmcb_temp_stack16

	push	ds
	pop	es
	
	mov	bl, cs:[rmcb_number]
	mov	bh,0
	shl	bx,3

	push	bx
	push	50			; copy the registers to protected memory
	push	ds
	push	offset _dpmisim_regs
	mov	eax,_dpmisim_rmcb[bx+4]
	add	eax,_ARENA
	push	eax
	call	_memput
	add	sp,10
	pop	bx

	mov	ax, _arena_cs		; cs:eip for function to call
	mov	_r_tss.tss_cs, ax
	mov	eax, _dpmisim_rmcb[bx]
	mov	_r_tss.tss_eip, eax

	mov	ax, _arena_ds		; es:edi for pointer to registers
	mov	_r_tss.tss_es, ax
	mov	eax, _dpmisim_rmcb[bx+4]
	mov	_r_tss.tss_edi, eax

	mov	ax, _core_selector	; ds:esi for pointer to caller stack
	mov	_r_tss.tss_ds, ax
	mov	eax,0
	mov	ax,ds_ss
	shl	eax,4
	mov	ebx,0
	mov	bx,ds_sp
	add	eax,ebx
	mov	_r_tss.tss_esi, eax

	mov	ax, _core_selector	; ss:esp for pointer to temp stack
	mov	_r_tss.tss_ss, ax
	mov	eax,0
	mov	ax,ds
	shl	eax,4
	mov	ebx,0
	mov	bx,offset rmcb_temp_stack32
	add	eax,ebx
	and	eax,0fffffffch
	mov	_r_tss.tss_esp, eax

	push	_tss_ptr
	mov	ax,offset _r_tss
	mov	_tss_ptr,ax

	call	_go_til_stop
	
	pop	_tss_ptr

	mov	bl, cs:[rmcb_number]
	mov	bh,0
	shl	bx,3

	push	bx	
	push	50			; copy the registers from protected memory
	push	ds
	push	offset _dpmisim_regs
	mov	eax,_dpmisim_rmcb[bx+4]
	add	eax,_ARENA
	push	eax
	call	_memget
	add	sp,10
	pop	bx

	mov	ss,ds_ss
	mov	sp,ds_sp

	mov	edi, ds_edi
	mov	esi, ds_esi
	mov	ebp, ds_ebp
	mov	ebx, ds_ebx
	mov	edx, ds_edx
	mov	ecx, ds_ecx
	mov	eax, ds_eax
	mov	es, ds_es
	mov	fs, ds_fs
	mov	gs, ds_gs

	push	ds_flg
	push	ds_cs
	push	ds_ip
	mov	ds, ds_ds
	iret			; jmp to wherever the regs said to

rmcb_task_switch:
	jmpt	g_ctss

	end_code16

;------------------------------------------------------------------------

	end
