/* This is file mm.c */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <dir.h>
#include <dos.h>

main()
{
  FILE *fin, *fout;
  char buf[200];
  fin = fopen("maketmpl", "r");
  fout = fopen("makefile.n", "w");
  fprintf(fout, "# This file is generated from maketmpl by mm.c\n");
  while (fgets(buf, 200, fin) != NULL)
  {
    if (strncmp(buf, "@dir ", 5) == 0)
      handle_dir(fout, buf+5);
    else if (strncmp(buf, "@dir2 ", 6) == 0)
      handle_dir2(fout, buf+6);
    else
      fputs(buf, fout);
  }
  fclose(fin);
  fclose(fout);
}

handle_dir(FILE *f, char *line)
{
  char fname[100];
  sscanf(line, "%s", fname);
  handle_wild(f, fname, "*.c");
  handle_wild(f, fname, "*.cc");
  handle_wild(f, fname, "*.S");
}

handle_wild(FILE *f, char *dir, char *wild)
{
  struct ffblk ff;
  char buf[100], *cp;
  int done;
  sprintf(buf, "%s/%s", dir, wild);
  done = findfirst(buf, &ff, FA_ARCH | FA_RDONLY);
  while (!done)
  {
    fputs("\t$(ODIR)/", f);
    sprintf(buf, "%s", ff.ff_name);
    strlwr(buf);
    cp = strrchr(buf, '.');
    strcpy(cp, ".o \\\n");
    fputs(buf, f);
    done = findnext(&ff);
  }
}

handle_dir2(FILE *f, char *line)
{
  char fname[100];
  sscanf(line, "%s", fname);
  handle_wild2(f, fname, "*.c");
  handle_wild2(f, fname, "*.cc");
  handle_wild2(f, fname, "*.S");
}

handle_wild2(FILE *f, char *dir, char *wild)
{
  struct ffblk ff;
  char buf[100], *cp;
  int done;
  sprintf(buf, "%s/%s", dir, wild);
  done = findfirst(buf, &ff, FA_ARCH | FA_RDONLY);
  while (!done)
  {
    strcpy(buf, ff.ff_name);
    strlwr(buf);
    cp = strrchr(buf, '.');
    *cp = 0;

    fprintf(f, "$(ODIR)/%s.o : %s/%s%s\n", buf, dir, buf, wild+1);
    fprintf(f, "\tgcc $(PG) $(CFLAGS) -c %s/%s%s -o $(ODIR)/%s.o\n",
	    dir, buf, wild+1, buf);
    fprintf(f, "\n");

    done = findnext(&ff);
  }
}
