/* This is file GETCBRK.C */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <dos.h>
#include <errno.h>

int getcbrk()
{
  union REGS r;
  r.h.ah = 0x33;
  r.h.al = 0;
  int86(0x21, &r, &r);
  return r.h.dl;
}

int setcbrk(int v)
{
  union REGS r;
  r.h.ah = 0x33;
  r.h.al = 1;
  r.h.dl = v;
  int86(0x21, &r, &r);
  return v;
}
