@echo off
echo Configuring GNU Sed for DJGPP v2.x...

Rem The SmallEnv tests protect against fixed and too small size
Rem of the environment in stock DOS shell.

Rem Find out if NLS is wanted or not,
Rem if GNU regex or DJGPP regex is wanted
Rem and where the sources are.
Rem We always default to NLS support,
Rem GNU regex, and to in place configuration.
set ARGS=
set NLS=enabled
if not "%NLS%" == "enabled" goto SmallEnv
set GNU_REGEX=enabled
if not "%GNU_REGEX%" == "enabled" goto SmallEnv
set XSRC=.
if not "%XSRC%" == "." goto SmallEnv

Rem Loop over all arguments.
Rem Special arguments are: NLS, XSRC and REGEX.
Rem All other arguments are stored into ARGS.
:ArgLoop
set ARGSFLAG=1
if not "%ARGSFLAG%" == "1" goto SmallEnv
if not "%1" == "NLS" if not "%1" == "nls" if not "%1" == "NO-NLS" if not "%1" == "no-NLS" if not "%1" == "no-nls" goto RegexOpt
if "%1" == "no-nls" set NLS=disabled
if "%1" == "no-NLS" set NLS=disabled
if "%1" == "NO-NLS" set NLS=disabled
if not "%NLS%" == "disabled" goto SmallEnv
set ARGSFLAG=0
if not "%ARGSFLAG%" == "0" goto SmallEnv
shift
:RegexOpt
set ARGSFLAG=1
if not "%ARGSFLAG%" == "1" goto SmallEnv
if not "%1" == "regex" if not "%1" == "REGEX" if not "%1" == "no-regex" if not "%1" == "no-REGEX" if not "%1" == "NO-REGEX" goto SrcDirOpt
if "%1" == "no-regex" set GNU_REGEX=disabled
if "%1" == "no-REGEX" set GNU_REGEX=disabled
if "%1" == "NO-REGEX" set GNU_REGEX=disabled
if not "%GNU_REGEX%" == "disabled" goto SmallEnv
set ARGSFLAG=0
if not "%ARGSFLAG%" == "0" goto SmallEnv
shift
:SrcDirOpt
set ARGSFLAG=1
if not "%ARGSFLAG%" == "1" goto SmallEnv
echo %1 | grep -q "/"
if errorlevel 1 goto NextArg
set XSRC=%1
if not "%XSRC%" == "%1" goto SmallEnv
set ARGSFLAG=0
if not "%ARGSFLAG%" == "0" goto SmallEnv
:NextArg
if "%ARGSFLAG%" == "1" set _ARGS=%ARGS% %1
if "%ARGSFLAG%" == "1" if not "%_ARGS%" == "%ARGS% %1" goto SmallEnv
set ARGS=%_ARGS%
set _ARGS=
shift
if not "%1" == "" goto ArgLoop
set ARGSFLAG=

if "%XSRC%" == "." goto InPlace

:NotInPlace
redir -e /dev/null update %XSRC%/configure.orig ./configure
test -f ./configure
if errorlevel 1 update %XSRC%/configure ./configure

:InPlace
Rem Update configuration files
echo Updating configuration scripts...
test -f ./configure.orig
if errorlevel 1 update configure configure.orig
sed -f %XSRC%/djgpp/config.sed configure.orig > configure
if errorlevel 1 goto SedError

Rem Make sure they have a config.site file
set CONFIG_SITE=%XSRC%/djgpp/config.site
if not "%CONFIG_SITE%" == "%XSRC%/djgpp/config.site" goto SmallEnv

Rem Make sure crucial file names are not munged by unpacking
test -f %XSRC%/config.h.in
if not errorlevel 1 mv -f %XSRC%/config.h.in %XSRC%/config.h-in
test -f %XSRC%/intl/po2tbl.sed.in
if not errorlevel 1 mv -f %XSRC%/intl/po2tbl.sed.in %XSRC%/intl/po2tblsed.in
test -f %XSRC%/intl/po2tbl.sed
if not errorlevel 1 mv -f %XSRC%/intl/po2tbl.sed %XSRC%/intl/po2tblsed.in
test -f %XSRC%/intl/po2tbl-sed.in
if not errorlevel 1 mv -f %XSRC%/intl/po2tbl-sed.in %XSRC%/intl/po2tblsed.in
test -f %XSRC%/po/Makefile.in.in
if not errorlevel 1 mv -f %XSRC%/po/Makefile.in.in %XSRC%/po/Makefile.in-in
test -f %XSRC%/po/Makefile.am.in
if not errorlevel 1 mv -f %XSRC%/po/Makefile.am.in %XSRC%/po/Makefile.am-in

Rem This is required because DOS/Windows are case-insensitive
Rem to file names, and "make install" will do nothing if Make
Rem finds a file called `install'.
if exist INSTALL ren INSTALL INSTALL.txt

Rem Set HOSTNAME so it shows in config.status
if not "%HOSTNAME%" == "" goto hostdone
if "%windir%" == "" goto msdos
set OS=MS-Windows
if not "%OS%" == "MS-Windows" goto SmallEnv
goto haveos
:msdos
set OS=MS-DOS
if not "%OS%" == "MS-DOS" goto SmallEnv
:haveos
if not "%USERNAME%" == "" goto haveuname
if not "%USER%" == "" goto haveuser
echo No USERNAME and no USER found in the environment, using default values
set HOSTNAME=Unknown PC
if not "%HOSTNAME%" == "Unknown PC" goto SmallEnv
goto userdone
:haveuser
set HOSTNAME=%USER%'s PC
if not "%HOSTNAME%" == "%USER%'s PC" goto SmallEnv
goto userdone
:haveuname
set HOSTNAME=%USERNAME%'s PC
if not "%HOSTNAME%" == "%USERNAME%'s PC" goto SmallEnv
:userdone
set _HOSTNAME=%HOSTNAME%, %OS%
if not "%_HOSTNAME%" == "%HOSTNAME%, %OS%" goto SmallEnv
set HOSTNAME=%_HOSTNAME%
:hostdone
set _HOSTNAME=
set OS=

Rem install-sh is required by the configure script but clashes with the
Rem various Makefile install-foo targets, so we MUST have it before the
Rem script runs and rename it afterwards
test -f %XSRC%/install-sh
if not errorlevel 1 goto NoRen0
test -f %XSRC%/install-sh.sh
if not errorlevel 1 mv -f %XSRC%/install-sh.sh %XSRC%/install-sh
:NoRen0

if "%NLS%" == "disabled" goto WithoutNLS

:WithNLS
Rem Check for the needed libraries and binaries.
test -x /dev/env/DJDIR/bin/msgfmt.exe
if not errorlevel 0 goto WithoutNLS
test -x /dev/env/DJDIR/bin/xgettext.exe
if not errorlevel 0 goto WithoutNLS
test -f /dev/env/DJDIR/lib/libcharset.a
if not errorlevel 0 goto WithoutNLS
test -f /dev/env/DJDIR/lib/libiconv.a
if not errorlevel 0 goto WithoutNLS
test -f /dev/env/DJDIR/lib/libintl.a
if not errorlevel 0 goto WithoutNLS

Rem Recreate the files in the %XSRC%/po subdir with our ported tools.
redir -e /dev/null rm %XSRC%/po/*.gmo
redir -e /dev/null rm %XSRC%/po/sed.pot
redir -e /dev/null rm %XSRC%/po/cat-id-tbl.c
redir -e /dev/null rm %XSRC%/po/stamp-cat-id

Rem Fix the broken .po files.
sh %XSRC%/djgpp/po_fix.sh

Rem We prefer without-included-gettext because libintl.a from gettext package
Rem is the only one that is garanteed to have been ported to DJGPP.
echo Running the ./configure script...
if "%GNU_REGEX%" == "enabled" goto WithGNURegex
sh ./configure --src=%XSRC% --enable-nls --without-included-gettext --with-regex=/dev/env/DJDIR/lib/libc.a %ARGS%
if errorlevel 1 goto CfgError
echo Done.
goto ScriptEditing
:WithGNURegex
sh ./configure --src=%XSRC% --enable-nls --without-included-gettext %ARGS%
if errorlevel 1 goto CfgError
echo Done.
goto ScriptEditing

:WithoutNLS
echo Running the ./configure script...
if "%GNU_REGEX%" == "disabled" goto WithDJGPPRegex
sh ./configure --src=%XSRC% --disable-nls %ARGS%
if errorlevel 1 goto CfgError
goto ScriptEditing
echo Done.
:WithDJGPPRegex
sh ./configure --src=%XSRC% --disable-nls --with-regex=/dev/env/DJDIR/lib/libc.a %ARGS%
if errorlevel 1 goto CfgError
echo Done.

:ScriptEditing
Rem unix EOL must be converted to msdos EOL
Rem or the cmp program will fail.
test -f %XSRC%/testsuite/stamp-test
if not errorlevel 1 goto End
utod %XSRC%/testsuite/*.*
touch %XSRC%/testsuite/stamp-test
goto End

:SedError
echo ./configure script editing failed!
goto End

:CfgError
echo ./configure script exited abnormally!
goto End

:SmallEnv
echo Your environment size is too small.  Enlarge it and run me again.
echo Configuration NOT done!

:End
test -f %XSRC%/install-sh.sh
if not errorlevel 1 goto NoRen1
test -f %XSRC%/install-sh
if not errorlevel 1 mv -f %XSRC%/install-sh %XSRC%/install-sh.sh
:NoRen1
set ARGS=
set CONFIG_SITE=
set HOSTNAME=
set NLS=
set GNU_REGEX=
set XSRC=
