#! /bin/sh

dry_run=

declare -a fix_files
declare -a lfns
declare -a sfns

pipe=\|
minus=\-

srcdir=".."

function sfnfix()
{
  declare -i i
  i=0
  num_files="${#lfns[@]}"
  unset sed_args
  declare -a sed_args
  
  echo "Entering directory $PWD..."

  while [ $i -lt $num_files ]; do
    sed_args[${#sed_args[@]}]="${minus}e"
    sed_args[${#sed_args[@]}]="s${pipe}${lfns[i]}${pipe}${sfns[i]}${pipe}g"
    let i+=1
  done
  for fix in "${fix_files[@]}"; do
    if test -z "$fix"; then
      break;
    fi
    if ! test -f "$fix"; then
      echo "$fix doesn't exist."
      continue
    fi
    echo "Fixing $fix..."
    if test -z $dry_run; then
      sed "${sed_args[@]}" < $fix > fix.tmp
      rm $fix
      mv fix.tmp $fix
    fi
  done
  i=0
  while [ $i -lt $num_files ]; do
    if test -f "${lfns[i]}"; then
      echo "Renaming ${lfns[i]} -> ${sfns[i]}"
      if test -z $dry_run; then
        mv "${lfns[i]}" "${sfns[i]}"
      fi
    fi
    let i+=1
  done
  fix_files=
  echo
}

lfns=("y.tab.c" "y.tab.h" "y.tab.o")
sfns=("y_tab.c" "y_tab.h" "y_tab.o")
fix_files=( "AUTHORS" "CWRU/changelog" "MANIFEST" "Makefile.in" \
            "execute_cmd.c" "parse.y" "print_cmd.c" "support/missing" \
            "support/mkclone" "support/xenix-link.sh")

(cd $srcdir; sfnfix)

lfns=("config.h.in")
sfns=("config.h-in")
fix_files=( "AUTHORS" "MANIFEST" "Makefile.in" "configure.in" "configure" \
            "support/missing" "tests/errors.tests" )
(cd $srcdir; sfnfix)

lfns=("\.made" "\.build")
sfns=("_made" "_build")
fix_files=( "Makefile.in" )
(cd $srcdir; sfnfix)

lfns=( "builtins2.sub" "run-arith-for" "run-array2" "run-extglob2" \
      "run-histexpand" "run-posix2" )
sfns=( "builtns2.sub" "runarithfor" "runarray2" "runextglob2" \
      "runhistexpand" "runposix2" )
fix_files=
(cd $srcdir/tests; sfnfix)

lfns=("basename2" "complete/complete2.ianmac" "scripts/scrollbar2")
sfns=("basenam2" "complete/complet2.ianmac" "scripts/scrolbar2")
fixfiles=
(cd $srcdir/examples; sfnfix)

lfns=("termcap.info-1" "termcap.info-2" "termcap.info-3" "termcap.info-4")
sfns=("termcap.i1" "termcap.i2" "termcap.i3" "termcap.i4")
fix_files=("termcap.info")
(cd $srcdir/lib/termcap/grot; sfnfix)
