
/*
 * Packet De-Fragmentaion code for WATTCP
 * Written by and COPYRIGHT (c)1993 to Quentin Smart
 *                               smart@actrix.gen.nz
 * all rights reserved.
 *
 *   This software is distributed in the hope that it will be useful,
 *   but without any warranty; without even the implied warranty of
 *   merchantability or fitness for a particular purpose.
 *
 *   You may freely distribute this source code, but if distributed for
 *   financial gain then only executables derived from the source may be
 *   sold.
 *
 *
 * Based on RFC815
 */

#include <stdlib.h>
#include "wattcp.h"

#define MAXBUFS         5       /* maximum number of Ethernet buffers */
#define MAXFRAGS        MAXBUFS-1
#define FRAGHOLDTIME    15       /* 15 secs to hold before discarding */
#define INFINITY        30000
#define IP_MF           0x0020  /* More fragment in INTEL form */

typedef struct _fragkey{
  longword source;
  longword destination;
  word     identification;
} fragkey;

typedef struct _hole_descr {
  struct _hole_descr * next;
  int start;
  int end;
} hole_descr;

typedef struct _fraghdr {
  byte         used;           /* this position in table in use */
  longword     timer;
  fragkey      key;
  hole_descr  *hole_first;
  in_Header   *ip;
  byte        *data_offset;
} fraghdr;

static fraghdr fraglist[MAXFRAGS] = {{0},{0},{0},{0}};

int active_frags = 0;
extern word _pktipofs;  /* offset from header to start of pkt */

/* Fragment is called if the frag section of
   the IP header is not zero or Frag Bit is set
   and Don't frag bit is not set */

byte *fragment (in_Header *ip)
{
  int i;

  fragkey key;
  fraghdr *my_frag;

  int data_start;
  int data_length;
  int data_end;
  int more_frags;

  hole_descr *hole = NULL;
  hole_descr *prev_hole = NULL;

  /* Should do checksum on packet. */

  /* Assemble key */
  key.source = ip->source;
  key.destination = ip->destination;
  key.identification = ip->identification;

  /* Check if we have a match */
  my_frag = NULL;
  for (i=0; i<MAXFRAGS; i++)
  {
    if (fraglist[i].used &&
	key.source == fraglist[i].key.source &&
	key.destination == fraglist[i].key.destination &&
	key.identification == fraglist[i].key.identification)
    {
#ifdef TCPDEB /*debug*/
{
FILE *fd = fopen("debug.txt","a");
fprintf(fd,"frag find %d\n",i);
fclose(fd);
}
#endif
       my_frag = &fraglist[i];
       break;
    }
  }

  if (!my_frag && active_frags == MAXFRAGS)
  {
     /* Can't handle any new frags */
     pkt_buf_release((char*)ip);
     return(NULL);
  }

  data_start  = (intel16(ip->frags) & 0x1FF) << 3;
  data_length = intel16(ip->length)-in_GetHdrlenBytes(ip);
  data_end    = data_start + data_length;
  more_frags  = ip->frags & IP_MF;
#ifdef TCPDEB /*debug*/
{
FILE *fd = fopen("debug.txt","a");
fprintf(fd,"frag inf s=%d, l=%d, e=%d, m=%d\n",
data_start,data_length,data_end,more_frags);
fclose(fd);
}
#endif

  if (!my_frag)
  {
     /* Mark as used */
     *((byte *)ip - (2 + _pktipofs)) = 2;

     /* Find first empty slot */
     for (i=0; i<MAXFRAGS; i++)
       if (!fraglist[i].used) break;

#ifdef TCPDEB /*debug*/
{
FILE *fd = fopen("debug.txt","a");
fprintf(fd,"frag new %d\n",i);
fclose(fd);
}
#endif
     my_frag = &fraglist[i];
     my_frag->used = 1;

     /* inc active frags counter */
     active_frags++;

     memcpy(&(my_frag->key),&key,sizeof(fragkey));
     my_frag->timer = set_timeout (max (FRAGHOLDTIME,ip->ttl) );
     my_frag->ip = ip;

     /* Set pointers to beinging of IP packet data */
     my_frag->data_offset = (byte *)my_frag->ip + in_GetHdrlenBytes(ip);

     /* Setup initial hole table */

     if (data_start) /* not begin of data */
     {
       /* copy data from this packet into proper place*/
       memcpy(
	 my_frag->data_offset + data_start,
	 my_frag->data_offset,
	 data_length
       );
       /* Bracket beginning of data */
       hole = my_frag->hole_first = (hole_descr *)my_frag->data_offset;
       hole->start = 0;
       hole->end = data_start;
       hole->next = NULL;

       /* Bracket ending of data */
       if (more_frags)
       {
	 hole->next = (hole_descr *)(my_frag->data_offset + data_end);
	 hole = hole->next;
	 hole->start = data_end;
	 hole->end = INFINITY;
	 hole->next = NULL;
       }
       else
       {
	 /* Adjust ip length, with size from last frag. */
	 ip->length = intel16 (data_end + in_GetHdrlenBytes(ip));
       }
     }
     else
     {
       hole = my_frag->hole_first = (hole_descr *)(my_frag->data_offset + data_end);
       hole->start = data_end;
       hole->end = INFINITY;
       hole->next = NULL;
     }
     return NULL; /* Go back for more! */
  } /* end frag. from new ip datagram */

  /* Adjust length */
  if (!more_frags)
    my_frag->ip->length = intel16 (data_end + in_GetHdrlenBytes(ip));

  /* Hole handling */
  prev_hole = NULL;
  hole = my_frag->hole_first;

  while (hole)
  {
    if (data_start >= hole->start && data_end <= hole->end)
    {
      int tend = hole->end;

      /* Check is there a hole before the new frag */
      if (data_start > hole->start)
      {
	hole->end = data_start;
	prev_hole = hole;
      }
      else
      {
	if (!prev_hole)
	  my_frag->hole_first=hole->next;
	else
	  prev_hole->next = hole->next;
      }
 
      /* Is there a hole after the current fragment */
      if (data_end < hole->end && more_frags)
      {
	hole = (hole_descr *) (my_frag->data_offset + data_end);
	hole->start = data_end;
	hole->end = tend;
	if (!prev_hole)
	{
	  hole->next = my_frag->hole_first;
	  my_frag->hole_first = hole;
	}
	else
	{
	  hole->next = prev_hole->next;
	  prev_hole->next = hole;
	}
      }
      /* find hole */
      memcpy(
	my_frag->data_offset + data_start,
	(byte *)ip+in_GetHdrlenBytes(ip),
	data_length);
      pkt_buf_release((byte *)ip);
      break;
    }
    prev_hole = hole;
    hole = hole->next;
  }
   
  /* Now do we have all the parts? */
  if (!my_frag->hole_first)
  {
    my_frag->used = 0;
    active_frags--;
    /* Redo checksum as we've changed the length in the header */
    my_frag->ip->checksum = 0; /* Zero */
    my_frag->ip->checksum = ~checksum( my_frag->ip, sizeof( in_Header ));
#ifdef TCPDEB /*debug*/
{
FILE *fd = fopen("debug.txt","a");
fprintf(fd,"frag end\n");
fclose(fd);
}
#endif
    return ((byte *)my_frag->ip) - _pktipofs;
  }

  return NULL;
}

void timeout_frags(void)
{
  int i;

  for (i=0; i<MAXFRAGS; i++)
  {
    if (fraglist[i].used && chk_timeout(fraglist[i].timer))
    {
      /* release fragment, timeout */
#ifdef TCPDEB /*debug*/
{
FILE *fd = fopen("debug.txt","a");
fprintf(fd,"frag rel %d\n",i);
fclose(fd);
}
#endif
      fraglist[i].used = 0;
      active_frags--;
      pkt_buf_release((byte *)fraglist[i].ip);
    }
  }
}
