/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem  : Quite sofisticated tools
	CommandNos : 4100..4199
	File       : Include/Tools/CmdWin.H
	Author     : Eric NICOLAS
	Overview   : Command Window
	UpDate     : Mar 01, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _TOOLS_CMDWIN_H_
#define _TOOLS_CMDWIN_H_

#define cmCommand 4100

class TCommandViewer;
class TCommandEdit;
class TCommandWindow;

// --- TCommandViewer

extern short RegTCommandViewer;
extern char *IdentTCommandViewer;

class TCommandViewer : public TTextScroller
{ DECLARE(TCommandViewer);
  // --- Datas
  protected:
  // --- Functions
  public:
  // Public constructors
          TCommandViewer(void);
          TCommandViewer(int X, int Y, int L, int H, TLift *_Vert);
          TCommandViewer(TRect R, TLift *_Vert);
  // Construction / Destruction
          void     Defaults(void);
			 void     Init(int X, int Y, int L, int H, TLift *_Vert);
  //
  virtual char    *GetText(int Line);
};

// --- TCommandEdit

extern short RegTCommandEdit;
extern char *IdentTCommandEdit;

class TCommandEdit : public TEditLine
{ // --- Datas
  public:
    TCommandWindow *CmdWin;
  // --- Functions
  public:
  // Public constructors
          TCommandEdit(void);
          TCommandEdit(int X, int Y, int L);
  // Construction / Destruction
          void    Defaults(void);
          void    Init(int X, int Y, int L);
  //
  virtual boolean KeyDown(int ScanCode, int Toggle);
};

// --- TCommandWindow

extern short RegTCommandWindow;
extern char *IdentTCommandWindow;

class TCommandWindow : public TStdWindow
{ DECLARE(TCommandWindow);
  // --- Datas
  protected:
    TCommandEdit   *Editor;
    TCommandViewer *Viewer;
    TLift          *VLift;
  // --- Functions
  public:
  // Public constructor
           TCommandWindow();
           TCommandWindow(char *Title);
           TCommandWindow(int X, int Y, int L, int H, char *Title);
  // Construction / Destruction
           void Defaults(void);
           void Init(int X, int Y, int L, int H, char *Title);
  //
           void ExecuteCommand(void);
};

#endif // _TOOLS_CMDWIN_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   21/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   01/03/96 :EN: Moving from struct to class. Adding Defaults() method
** ------------------------------------------------------------------------*/
