/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem  : Little usefull graphical objects
	File       : Include/Gadgets/Scroller.H
	Author     : Eric NICOLAS
	Overview   : TScroller object
	UpDate     : Apr 08, 1996

** Copyright (C) 1993-1996 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GADGETS_SCROLLER_H_
#define _GADGETS_SCROLLER_H_

class TScroller;

// --- TScroller object

extern short RegTScroller;
extern char *IdentTScroller;

class TScroller : public TZone
{ DECLARE(TScroller);
  DECLARE_EVENTS_TABLE;
  // --- Datas
  protected:
    TLift *Horiz, *Vert;
    int    WideL,  WideH;
    int    DecX,   DecY;
    int    StepX,  StepY;
  // --- Functions
  public:
  // Public constructors
			 TScroller(void);
			 TScroller(int X, int Y, int L, int H, int WL, int WH, TLift *_Horiz, TLift *_Vert);
          TScroller(TRect R, int WL, int WH, TLift *_Horiz, TLift *_Vert);
  // Construction / Destruction
          void     Defaults(void);
			 void     Init(int X, int Y, int L, int H, int WL, int WH, TLift *_Horiz, TLift *_Vert);
  // Gestion des ascenseurs
  virtual void     SizeChanged(void);
  virtual void     Draw(TRect Clip);
          boolean  doLiftHorizMoved(void);
          boolean  doLiftVertMoved(void);
};

#endif // _GADGETS_SCROLLER_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   21/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   01/03/96 :EN: Moving from struct to class. Adding Defaults() method
**   01/04/96 :EN: Adding DECLARE_COMMAND... macros
**   08/04/96 :EN: Changing from DECLARE_COMMAND... to DECLARE_EVENTS...
** ------------------------------------------------------------------------*/
