/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem  : Little usefull graphical objects
	CommandNos : 3100..3199
	File       : Include/Gadgets/Button.H
	Authors    : Olivier PAYEN, Eric NICOLAS
	Overview   : Objects TButton and TStdButton
	UpDate     : Apr 08, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GADGETS_BUTTON_H_
#define _GADGETS_BUTTON_H_

class TButton;
class TStdButton;
class TOkButton;
class TCancelButton;
class TYesButton;
class TNoButton;

// Buttons options

#define boDisabled        0x0001
#define boImmediate       0x0002
#define boRepetition      0x0004
#define boNoCase          0x0008
#define boShiftedScanCode 0x0010

// Global commands

#define cmButtonReAction 3100
#define cmOK             3101
#define cmCancel         3102
#define cmYes            3103
#define cmNo             3104
#define cmCommandEnable  3105
#define cmCommandDisable 3106

// ----- TButton

extern short RegTButton;
extern char *IdentTButton;

class TButton : public TZone
{ DECLARE(TButton);
  DECLARE_EVENTS_TABLE;
  // --- Datas
  protected:
    long    Command;
    int     ScanCode;
    int     ButtonOptions;
    TRect   RectChanging;
  public:
  // Public constructors
          TButton(void);
          TButton(int X ,int Y, int L, int H, long _Command, int _ScanCode, int _Options);
          TButton(TRect R, long _Command, int _ScanCode, int _Options);
  // Construction / Destruction
          void     Defaults(void);
          void     Init(int X, int Y, int L, int H, long _Command, int _ScanCode, int _Options);
  // Events
          boolean  MouseLDown(TPoint Where, int Buttons);
          boolean  MouseLUp(TPoint Where, int Buttons);
          boolean  KeyDown(int ScanCode, int Toggle);
          boolean  doChangeSelect(void);
          boolean  doButtonReAction(void);
  // Graphics
  virtual int      DrawFrame(void);
  virtual void     DrawInside(int Depl);
  virtual void     Draw(TRect Clip);
          void     DrawSelect(int Depl);
  // Action
  virtual void     Action(void);
          void     KeyboardAction(void);
  // Objects streams
  virtual void     Read(TDisk* file);
  virtual void     Write(TDisk* file);
};

// ----- TStdButton

extern short RegTStdButton;
extern char *IdentTStdButton;

class TStdButton : public TButton
{ DECLARE(TStdButton);
  // --- Datas
  protected:
    char     *Text,*ParamText;
    TMapping *Mapp;
    int       dXT, dYT;
    int       dXM, dYM;
  // --- Functions
  public:
  // Public constructors
          TStdButton(void);
          TStdButton(int X, int Y, int L, int H, long _Command, int _ScanCode, int _Options, char* _Text, TMapping *_Mapp=NULL);
          TStdButton(TRect R, long _Command, int _ScanCode, int _Options, char* _Text, TMapping* _Mapp=NULL);
  // Construction / Destruction
          void     Defaults(void);
          void     Init(int X, int Y, int L, int H, long _Command,
                        int _ScanCode, int _Options, char* _Text, TMapping *_Mapp);
          void     Done(void);
  // Graphics
  virtual void     DrawInside(int Depl);
  // Objects streams
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
};

// ----- Standard Buttons

class TOKButton : public TStdButton
{ public:
    TOKButton(int X, int Y);
};

class TCancelButton : public TStdButton
{ public:
    TCancelButton(int X, int Y);
};

class TYesButton : public TStdButton
{ public:
    TYesButton(int X, int Y);
};

class TNoButton : public TStdButton
{ public:
    TNoButton(int X, int Y);
};

#endif // _GADGETS_BUTTON_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   21/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   29/02/96 :EN: Changing from struct to class. Adding Defaults() methods
**   03/03/96 :EN: Changing color scheme so that it can be user-modified
**   01/04/96 :EN: Adding DECLARE_COMMAND... macros
**   03/04/96 :EN: Bug fixed in doButtonReAction. The event is not destroyed
**                 if *this button is not concerned
**   08/04/96 :EN: Changing from DECLARE_COMMAND... to DECLARE_EVENTS...
** ------------------------------------------------------------------------*/
