//-------------------------------------------------------------------------
//                   Calcul de C.I.R.     REOSC 94
//                   Eric NICOLAS - Laurent COGNET
//-------------------------------------------------------------------------
// SAISIE.CC
//   Diverses procdures de saisie clavier
//-------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#ifdef __TURBOC__
  #include <conio.h>
#else
  #include <gppconio.h>
  #include <pc.h>
#endif
#include <math.h>
#include <dos.h>
#include "Saisie.H"

// Variables locales

char Insertion;
int   X,Y,L,Dep,Pos,LMax;
char *ChaineDep;
char *ChaineWork;
char *ChaineTemp;

// Procdures locales

int  Key;
char Status=0;

char GetChar()
{ if (Status)
  { Status=0;
    return (char)(Key-0x100);
  }
  else
  {
#ifdef __TURBOC__
    Key=getch();
#else
    Key=getxkey();
#endif
    if (Key>0xFF)
    { Status=1;
      return 0;
    }
    return (char)Key;
  }
}

void beep(void)
{/* sound(440);
  sleep(1);
  sound(0);*/
}

void SetCursorShape(char Ins)
{ REGS r;
  r.h.ah=0x01;
  if (Ins) r.h.ch=6; else r.h.ch=0;
  r.h.cl=7;
  int86(0x10,&r,&r);
}

//

char AskDigit(char Max)
{ char X=wherex();
  char Y=wherey();
  char Rep;
  char Temp[2];
  textattr(0x3B);
  do
  { gotoxy(X,Y); cputs("_");
    gotoxy(X,Y); Rep=GetChar();
    Temp[0]=Rep; Temp[1]=0; cputs(Temp);
    Rep-='0';
  } while((Rep<0)||(Rep>Max));
  textattr(0x07);
  return Rep;
}

char ValideAll(int& Ch)
{ if (Ch>=' ') return 1;
	  else return 0;
}

char ValidePath(int& Ch)
{ Ch=toupper(Ch);
  if (Ch>=' ') return 1;
          else return 0;
  /**** Filtrage plus subtil, mais pas forcment ncssaire
        Enlev dans version 1.01
   if ( ((Ch>='A')&&(Ch<='Z')) ||
	(Ch=='_')              ||
	(Ch==':')              ||
	(Ch=='\\')             ||
        (Ch=='.')              ||
	((Ch>='0')&&(Ch<='9'))
       ) return 1;
   else return 0;
  **********************************************************/
}

char ValideLecteur(int& Ch)
{ Ch=toupper(Ch);
  if ((Ch=='A')||(Ch=='B')||(Ch==':')) return 1;
  else return 0;
}

#define ChangeCur gotoxy(X+Pos-Dep,Y)

void Saisie_Aff(void)
{ strncpy(ChaineTemp,ChaineWork+Dep,L);
  ChaineTemp[L]=0;
  while(strlen(ChaineTemp)<L) strcat(ChaineTemp," ");
  gotoxy(X,Y);cputs(ChaineTemp);
  ChangeCur;
}

void Seek_Left()
{ if (Pos>0)
  { Pos--;
    if (Pos<Dep)
    { Dep-=5;
      if (Dep<0) Dep=0;
      Saisie_Aff();
    }
    else ChangeCur;
  }
}

void Seek_Right()
{ if (Pos<strlen(ChaineWork))
  { Pos++;
    if (Pos-Dep>L)
    { Dep+=5;
      Saisie_Aff();
    }
    else ChangeCur;
  }
}

void Seek_End()
{ Pos=strlen(ChaineWork);
  if (Pos-Dep>L)
  { Dep=Pos-L+5;
    Saisie_Aff();
  }
  else ChangeCur;
}

void Seek_Home()
{ Pos=0;
  if (Dep)
  { Dep=0;
    Saisie_Aff();
  }
  else ChangeCur;
}

void Insert(char Ch)
{ if (strlen(ChaineWork)==LMax) beep();
  else
  { memcpy(ChaineWork+Pos+1,ChaineWork+Pos,strlen(ChaineWork)-Pos+1);
    ChaineWork[Pos]=Ch;
    Pos++;
    if (Pos-Dep>L) Dep+=5;
    Saisie_Aff();
  }
}

void Recouvre(char Ch)
{ if (Pos==strlen(ChaineWork)) Insert(Ch);
  else
  { ChaineWork[Pos]=Ch;
    Pos++;
    if (Pos-Dep>L) Dep+=5;
    Saisie_Aff();
  }
}

void Saisie(char *Chaine, char Long, Validation Valide)
{ int Ch;
  // Initialise l'tat de Insert
  REGS r;
  r.h.ah=0x02;
  int86(0x16,&r,&r);
  Insertion=r.h.al & 0x80;
  SetCursorShape(Insertion);
  //
  textattr(0x70);
  X=wherex();
  Y=wherey();
  L=79-X+1;
  LMax=Long;
  if (L>Long) L=Long;
  ChaineWork=Chaine;
  ChaineDep=strdup(Chaine);
  ChaineTemp=(char*)malloc(L+1);
  Dep=0;Pos=0;
  Saisie_Aff();
  Seek_End();
  do
  { Ch=GetChar();
    switch(Ch)
    { case 0 :
	Ch=GetChar();
	switch(Ch)
        { case 82 :
            // Insert
            Insertion=!Insertion;
            SetCursorShape(Insertion);
            break;
          case 75 : Seek_Left();  break;
	  case 71 : Seek_Home();  break;
	  case 77 : Seek_Right(); break;
	  case 79 : Seek_End();   break;
          case 83 :
	    // Suppr
	    if (Pos<strlen(ChaineWork))
	    { memcpy(ChaineWork+Pos,ChaineWork+Pos+1,strlen(ChaineWork)-Pos);
	      Saisie_Aff();
	    } else beep();
	    break;
	}
	break;
      case 8 :
	// Delete
	if (Pos>0)
	{ Pos--;
	  if (Pos<Dep)
	  { Dep-=5;
	    if (Dep<0) Dep=0;
	  }
	  memcpy(ChaineWork+Pos,ChaineWork+Pos+1,strlen(ChaineWork)-Pos);
	  Saisie_Aff();
	} else beep();
	break;
      case 27 :
	strcpy(ChaineWork,ChaineDep);
	Saisie_Aff();
	break;
      case 13 :
	break;
      default :
	if (Valide(Ch))
	{ if (Insertion) Insert(Ch);
		    else Recouvre(Ch);
	}
	else beep();
	break;
    }
  } while(Ch!=13);
  free(ChaineDep);
  free(ChaineTemp);
  textattr(0x07);
  SetCursorShape(1);
}
