/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */ 
// WARNING: This is an internal header file, included by other C++
// standard library headers.  You should not attempt to use this header
// file directly.


#ifndef __SGI_STL_INTERNAL_MONETARY_H
#define __SGI_STL_INTERNAL_MONETARY_H

# include <stl/_num_facets.h>

__STL_BEGIN_NAMESPACE

class money_base {
public:
  enum part {none, space, symbol, sign, value};
  struct pattern {
    char field[4];
  };
};


// moneypunct facets: forward declaration
template <class _charT, __DFL_NON_TYPE_PARAM(bool, _International, false) > class moneypunct {};

// money_get facets

template <class _CharT, __DFL_TMPL_PARAM(_InputIter , istreambuf_iterator<_CharT>) >
class money_get : public locale::facet 
{
  friend class _Locale_impl;
#if defined(__MRC__) || defined(__SC__)	//*TY 04/29/2000 - added workaround for mpw
  typedef locale::facet _facet;			//*TY 04/29/2000 - they forget to look into nested class for the ctor.
#endif									//*TY 04/29/2000 - 
public:
  typedef _CharT               char_type;
  typedef _InputIter           iter_type;
  typedef basic_string<_CharT, char_traits<_CharT>, allocator<_CharT> > string_type;

#if !(defined(__MRC__)||defined(__SC__))	//*TY 02/26/2000 - added workaround for MPW compilers; explicit will prevent the compiler to find out the proper ctor
  explicit 
#endif										//*TY 02/26/2000 - 
  money_get(size_t __refs = 0)
#if !(defined(__MRC__) || defined(__SC__) )		//*TY 04/29/2000 - added workaround for mpw
  : locale::facet(__refs)
#else					//*TY 04/29/2000 - 
  : _facet(__refs)		//*TY 04/29/2000 - they forget to look into the nested class for the ctor
#endif					//*TY 04/29/2000 - 
  {}

  iter_type get(iter_type __s, iter_type  __end, bool __intl,
                ios_base&  __str, ios_base::iostate&  __err,
                long double& __units) const
    { return do_get(__s,  __end, __intl,  __str,  __err, __units); }
  
  iter_type get(iter_type __s, iter_type  __end, bool __intl,
                ios_base&  __str, ios_base::iostate& __err,
                string_type& __digits) const
    { return do_get(__s,  __end, __intl,  __str,  __err, __digits); }

  __STL_STATIC_MEMBER_DECLSPEC static locale::id id;

protected:
  ~money_get() {}
  virtual iter_type do_get(iter_type __s, iter_type  __end, bool  __intl,
                           ios_base&  __str, ios_base::iostate& __err,
                           long double& __units) const;
  virtual iter_type do_get(iter_type __s, iter_type __end, bool __intl,
                           ios_base&  __str, ios_base::iostate& __err,
                           string_type& __digits) const;

};



// moneypunct facets: definition of specializations

__STL_TEMPLATE_NULL
class __STL_CLASS_DECLSPEC moneypunct<char, true> : public locale::facet, public money_base 
{
  friend class _Locale_impl;
#if defined(__MRC__) || defined(__SC__)	//*TY 04/29/2000 - added workaround for mpw
  typedef locale::facet _facet;			//*TY 04/29/2000 - they forget to look into nested class for the ctor.
#endif									//*TY 04/29/2000 - 
public:
  typedef char                 char_type;
  typedef string               string_type;

  explicit moneypunct __STL_PSPEC2(char, true) (size_t __refs = 0);

  inline char        decimal_point() const { return do_decimal_point(); }
  inline char        thousands_sep() const { return do_thousands_sep(); }
  inline string      grouping()      const { return do_grouping(); }
  inline string_type curr_symbol()   const { return do_curr_symbol(); }
  inline string_type positive_sign() const { return do_positive_sign(); }
  inline string_type negative_sign() const { return do_negative_sign(); }
  inline int         frac_digits()   const { return do_frac_digits(); }
  inline pattern     pos_format()    const { return do_pos_format(); }
  inline pattern     neg_format()    const { return do_neg_format(); }

  __STL_STATIC_MEMBER_DECLSPEC static locale::id id;
# if defined (__STL_STATIC_CONST_INIT_BUG) || defined (__STL_USE_DECLSPEC)
  enum _IntlVal { intl = 1 } ;
# else
  static const bool intl = true;
# endif

protected:
  pattern _M_pos_format;
  pattern _M_neg_format;

  ~moneypunct __STL_PSPEC2(char, true) ();

  virtual char        do_decimal_point() const;
  virtual char        do_thousands_sep() const;
  virtual string      do_grouping()      const;

  virtual string_type do_curr_symbol()   const;

  virtual string_type do_positive_sign() const;
  virtual string_type do_negative_sign() const;
  virtual int         do_frac_digits()   const;
  virtual pattern     do_pos_format()    const;
  virtual pattern     do_neg_format()    const;
};

__STL_TEMPLATE_NULL
class __STL_CLASS_DECLSPEC moneypunct<char, false> : public locale::facet, public money_base 
{
  friend class _Locale_impl;
#if defined(__MRC__) || defined(__SC__)	//*TY 04/29/2000 - added workaround for mpw
  typedef locale::facet _facet;			//*TY 04/29/2000 - they forget to look into nested class for the ctor.
#endif									//*TY 04/29/2000 - 
public:
  typedef char                 char_type;
  typedef string               string_type;

  explicit moneypunct __STL_PSPEC2(char, false) (size_t __refs = 0);

  inline char        decimal_point() const { return do_decimal_point(); }
  inline char        thousands_sep() const { return do_thousands_sep(); }
  inline string      grouping()      const { return do_grouping(); }
  inline string_type curr_symbol()   const { return do_curr_symbol(); }
  inline string_type positive_sign() const { return do_positive_sign(); }
  inline string_type negative_sign() const { return do_negative_sign(); }
  inline int         frac_digits()   const { return do_frac_digits(); }
  inline pattern     pos_format()    const { return do_pos_format(); }
  inline pattern     neg_format()    const { return do_neg_format(); }

  __STL_STATIC_MEMBER_DECLSPEC static locale::id id;
# if defined (__STL_STATIC_CONST_INIT_BUG) || defined (__STL_USE_DECLSPEC)
  enum _IntlVal { intl = 0 } ;
# else
  static const bool intl = false;
# endif

protected:
  pattern _M_pos_format;
  pattern _M_neg_format;

  ~moneypunct __STL_PSPEC2(char, false) ();

  virtual char        do_decimal_point() const;
  virtual char        do_thousands_sep() const;
  virtual string      do_grouping()      const;

  virtual string_type do_curr_symbol()   const;

  virtual string_type do_positive_sign() const;
  virtual string_type do_negative_sign() const;
  virtual int         do_frac_digits()   const;
  virtual pattern     do_pos_format()    const;
  virtual pattern     do_neg_format()    const;
};


# ifndef __STL_NO_WCHAR_T

__STL_TEMPLATE_NULL
class __STL_CLASS_DECLSPEC moneypunct<wchar_t, true> : public locale::facet, public money_base 
{
  friend class _Locale_impl;
#if defined(__MRC__) || defined(__SC__)	//*TY 04/29/2000 - added workaround for mpw
  typedef locale::facet _facet;			//*TY 04/29/2000 - they forget to look into nested class for the ctor.
#endif									//*TY 04/29/2000 - 
public:
  typedef wchar_t                 char_type;
  typedef wstring                 string_type;

  explicit moneypunct __STL_PSPEC2(wchar_t, true) (size_t __refs = 0);

  inline wchar_t     decimal_point() const { return do_decimal_point(); }
  inline wchar_t     thousands_sep() const { return do_thousands_sep(); }
  inline string      grouping()      const { return do_grouping(); }
  inline string_type curr_symbol()   const { return do_curr_symbol(); }
  inline string_type positive_sign() const { return do_positive_sign(); }
  inline string_type negative_sign() const { return do_negative_sign(); }
  inline int         frac_digits()   const { return do_frac_digits(); }
  inline pattern     pos_format()    const { return do_pos_format(); }
  inline pattern     neg_format()    const { return do_neg_format(); }

  __STL_STATIC_MEMBER_DECLSPEC static locale::id id;
# if defined (__STL_STATIC_CONST_INIT_BUG) || defined (__STL_USE_DECLSPEC)
  enum _IntlVal { intl = 1 } ;
# else
  static const bool intl = true;
# endif

protected:
  pattern _M_pos_format;
  pattern _M_neg_format;

  ~moneypunct __STL_PSPEC2(wchar_t, true) ();

  virtual wchar_t     do_decimal_point() const;
  virtual wchar_t     do_thousands_sep() const;
  virtual string      do_grouping()      const;

  virtual string_type do_curr_symbol()   const;

  virtual string_type do_positive_sign() const;
  virtual string_type do_negative_sign() const;
  virtual int         do_frac_digits()   const;
  virtual pattern     do_pos_format()    const;
  virtual pattern     do_neg_format()    const;
};


__STL_TEMPLATE_NULL
class __STL_CLASS_DECLSPEC moneypunct<wchar_t, false> : public locale::facet, public money_base 
{
  friend class _Locale_impl;
#if defined(__MRC__) || defined(__SC__)	//*TY 04/29/2000 - added workaround for mpw
  typedef locale::facet _facet;			//*TY 04/29/2000 - they forget to look into nested class for the ctor.
#endif									//*TY 04/29/2000 - 
public:
  typedef wchar_t                 char_type;
  typedef wstring                 string_type;

  explicit moneypunct __STL_PSPEC2(wchar_t, false) (size_t __refs = 0);

  inline wchar_t     decimal_point() const { return do_decimal_point(); }
  inline wchar_t     thousands_sep() const { return do_thousands_sep(); }
  inline string      grouping()      const { return do_grouping(); }
  inline string_type curr_symbol()   const { return do_curr_symbol(); }
  inline string_type positive_sign() const { return do_positive_sign(); }
  inline string_type negative_sign() const { return do_negative_sign(); }
  inline int         frac_digits()   const { return do_frac_digits(); }
  inline pattern     pos_format()    const { return do_pos_format(); }
  inline pattern     neg_format()    const { return do_neg_format(); }

  __STL_STATIC_MEMBER_DECLSPEC static locale::id id;
# if defined (__STL_STATIC_CONST_INIT_BUG) || defined (__STL_USE_DECLSPEC)
  enum _IntlVal { intl = 0 } ;
# else
  static const bool intl = false;
# endif

protected:
  pattern _M_pos_format;
  pattern _M_neg_format;

  ~moneypunct __STL_PSPEC2(wchar_t, false) ();

  virtual wchar_t     do_decimal_point() const;
  virtual wchar_t     do_thousands_sep() const;
  virtual string      do_grouping()      const;

  virtual string_type do_curr_symbol()   const;

  virtual string_type do_positive_sign() const;
  virtual string_type do_negative_sign() const;
  virtual int         do_frac_digits()   const;
  virtual pattern     do_pos_format()    const;
  virtual pattern     do_neg_format()    const;
};

# endif

template <class _charT, __DFL_NON_TYPE_PARAM(bool , _International , false) > class moneypunct_byname {};

__STL_TEMPLATE_NULL
class __STL_CLASS_DECLSPEC moneypunct_byname<char, true> : public moneypunct<char, true> 
{
public:
  typedef money_base::pattern   pattern;
  typedef char                  char_type;
  typedef string                string_type;

  explicit moneypunct_byname __STL_PSPEC2(char, true) (const char * __name, size_t __refs = 0);

protected:
  _Locale_monetary* _M_monetary;
  ~moneypunct_byname __STL_PSPEC2(char, true) ();
  virtual char        do_decimal_point() const;
  virtual char        do_thousands_sep() const;
  virtual string      do_grouping()      const;

  virtual string_type do_curr_symbol()   const;

  virtual string_type do_positive_sign() const;
  virtual string_type do_negative_sign() const;
  virtual int         do_frac_digits()   const;
};

__STL_TEMPLATE_NULL
class __STL_CLASS_DECLSPEC moneypunct_byname<char, false> : public moneypunct<char, false> 
{
public:
  typedef money_base::pattern   pattern;
  typedef char                  char_type;
  typedef string                string_type;

  explicit moneypunct_byname __STL_PSPEC2(char, false) (const char * __name, size_t __refs = 0);

protected:
  _Locale_monetary* _M_monetary;
  ~moneypunct_byname __STL_PSPEC2(char, false) ();
  virtual char        do_decimal_point() const;
  virtual char        do_thousands_sep() const;
  virtual string      do_grouping()      const;

  virtual string_type do_curr_symbol()   const;

  virtual string_type do_positive_sign() const;
  virtual string_type do_negative_sign() const;
  virtual int         do_frac_digits()   const;
};

# ifndef __STL_NO_WCHAR_T
__STL_TEMPLATE_NULL
class __STL_CLASS_DECLSPEC moneypunct_byname<wchar_t, true> : public moneypunct<wchar_t, true> 
{
public:
  typedef money_base::pattern   pattern;
  typedef wchar_t               char_type;
  typedef wstring               string_type;

  explicit moneypunct_byname __STL_PSPEC2(wchar_t, true) (const char * __name, size_t __refs = 0);

protected:
  _Locale_monetary* _M_monetary;
  ~moneypunct_byname __STL_PSPEC2(wchar_t, true) ();
  virtual wchar_t     do_decimal_point() const;
  virtual wchar_t     do_thousands_sep() const;
  virtual string      do_grouping()      const;

  virtual string_type do_curr_symbol()   const;

  virtual string_type do_positive_sign() const;
  virtual string_type do_negative_sign() const;
  virtual int         do_frac_digits()   const;
};

__STL_TEMPLATE_NULL
class __STL_CLASS_DECLSPEC moneypunct_byname<wchar_t, false> : public moneypunct<wchar_t, false> 
{
public:
  typedef money_base::pattern   pattern;
  typedef wchar_t               char_type;
  typedef wstring               string_type;

  explicit moneypunct_byname __STL_PSPEC2(wchar_t, false) (const char * __name, size_t __refs = 0);

protected:
  _Locale_monetary* _M_monetary;
  ~moneypunct_byname __STL_PSPEC2(wchar_t, false) ();
  virtual wchar_t     do_decimal_point() const;
  virtual wchar_t     do_thousands_sep() const;
  virtual string      do_grouping()      const;

  virtual string_type do_curr_symbol()   const;

  virtual string_type do_positive_sign() const;
  virtual string_type do_negative_sign() const;
  virtual int         do_frac_digits()   const;
};
# endif

//===== methods ======


// money_put facets

template <class _CharT, __DFL_TMPL_PARAM( _OutputIter , ostreambuf_iterator<_CharT>) >
class money_put : public locale::facet {
  friend class _Locale_impl;
#if defined(__MRC__) || defined(__SC__)	//*TY 04/29/2000 - added workaround for mpw
  typedef locale::facet _facet;			//*TY 04/29/2000 - they forget to look into nested class for the ctor.
#endif									//*TY 04/29/2000 - 
public:
  typedef _CharT               char_type;
  typedef _OutputIter          iter_type;
  typedef basic_string<_CharT, char_traits<_CharT>, allocator<_CharT> > string_type;

#if !(defined(__MRC__)||defined(__SC__))	//*TY 02/26/2000 - added workaround for MPW compilers; explicit will prevent the compiler to find out the proper ctor
  explicit 
#endif										//*TY 02/26/2000 - 
  money_put(size_t __refs = 0);

  inline iter_type put(iter_type __s, bool __intl, ios_base& __str,
                       char_type  __fill, long double __units) const
    { return do_put(__s, __intl, __str, __fill, __units); }
  inline iter_type put(iter_type __s, bool __intl, ios_base& __str,
                       char_type  __fill, 
                       const string_type& __digits) const
    { return do_put(__s, __intl, __str, __fill, __digits); }

  __STL_STATIC_MEMBER_DECLSPEC static locale::id id;

protected:
  ~money_put();
  virtual iter_type do_put(iter_type __s, bool  __intl, ios_base&  __str,
                           char_type __fill, long double /*  __units */ ) const {

    locale __loc = __str.getloc();
    _CharT  __buf[64];
    //    _CharT* __buf_end = __write_monetary_value(__units, __buf, __loc);
    return do_put(__s, __intl, __str, __fill, __buf + 0);
  }
    
  virtual iter_type do_put(iter_type __s, bool  __intl, ios_base&  __str,
                           char_type __fill,
                           const string_type& __digits) const;
};

__STL_END_NAMESPACE

# if !defined (__STL_LINK_TIME_INSTANTIATION)
#  include <stl/_monetary.c>
# endif

#endif /* __SGI_STL_INTERNAL_MONETARY_H */

// Local Variables:
// mode:C++
// End:


