/*************************************************************
 ******************    ===Sound Test===    *******************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> WAVEWIN.CC
 -> Wave Window definition.
*/

#include "wavewin.h"
#include <tws/message.h>
#include <tws/sb.h>

#define DLG_WIDTH 250
#define DLG_HEIGHT 150

DEFINE_RESPONSE_TABLE(WaveWindow,TabWin)
   E_BUTTONUP(ID_SYSBOX,CmCancel)
   E_LBUTTONDOWN
END_RESPONSE_TABLE

char *cardtypes[]={
   "Sound Blaster 2.0",
   "Sound Blaster Pro",
   "Sound Blaster 16 (mono)",
   "Sound Blaster 16 (stereo)"
};

extern BYTE SBtype;
extern WORD SBdsp;
extern int MixingRate;

WaveWindow::WaveWindow(const char *filename)
   :TabWin(NULL,"Wave Player Window",(VideoData.width-DLG_WIDTH)/2,(VideoData.height-DLG_HEIGHT)/2,
      (VideoData.width+DLG_WIDTH)/2,(VideoData.height+DLG_HEIGHT)/2,WA_VISABLE | WA_BORDER | WA_CAPTION | WA_SYSBOX | WA_SAVEAREA)
{
   char temp[255];
   wave=LoadWaveFile(filename);

   cardname=new StaticText(this,cardtypes[SBtype],10,30,200);
   sprintf(temp,"DSP version : 0x%x",(int)SBdsp);
   dspversion=new StaticText(this,temp,10,60,200);
   sprintf(temp,"Mixing Rate : %d",(int)MixingRate);
   mixfreq=new StaticText(this,temp,10,90,200);
   sprintf(temp,"Wave filename : %s",filename);
   sampfreq=new StaticText(this,temp,10,120,200);
}

WaveWindow::~WaveWindow()
{
   delete sampfreq;
   delete mixfreq;
   delete dspversion;
   delete cardname;
   DeleteSample(wave);
}

void
WaveWindow::Run()
{
   Paint();
   RefreshWindow();
   if(!isValid())
   {
      MessageBox("Unable to open Wave file.","File Error").Run();
      return;
   }
   CatchMouse();
   CatchKeys();
   ws.StartSound();
   ws.RunEvents();
   ws.ResetEvents();
   ws.StopSound();
   StopAllSamples();
   ReleaseMouse();
   ReleaseKeys();
}

void
WaveWindow::CmCancel()
{
   ws.StopRunningEvents();
}

void
WaveWindow::LButtonDown(int x,int y,int)
{
   char temp[255];

   if(x>=absx && x<absx+w && y>=absy && y<absy+h)
      PlaySampleFVP(wave,wave->frequency,(y-absy)*65536/h,(x-absx)*65536/w);
}


