/*************************************************************
 ******************    ===Sound Test===    *******************
 *************************************************************
      Copyright (c)1996 Grafik Software by Malcolm Taylor

 -> SOUNDTST.H
 -> Declarations for menus and main classes.
*/

#ifndef _soundtst_h
#define _soundtst_h

#include <tws/system.h>
#include <tws/menu.h>

#define ID_SEPARATOR    -1

#define ID_FILE_OPEN             1
#define ID_SHELL_TO_DOS          2
#define ID_FILE_EXIT             3

#define ID_HELP_CONTENTS   100

PopupMenuRes FileMenuRes[]={
   {"&Open",ID_FILE_OPEN,0,0},
   {0,ID_SEPARATOR,0,0},
   {"Shell to &Dos",ID_SHELL_TO_DOS,0,0},
   {0,ID_SEPARATOR,0,0},
   {"E&xit",ID_FILE_EXIT,0,0}
};

#define NO_FILE_ITEMS 5

PopupMenuRes HelpMenuRes[]={
   {"&Contents",ID_HELP_CONTENTS,0,0}
};

#define NO_HELP_ITEMS 1

MenuRes MainMenuRes[]={
   {"&File",NO_FILE_ITEMS,FileMenuRes},
   {"&Help",NO_HELP_ITEMS,HelpMenuRes}
};

class MainMenu:public AutoMenu {
   public:
      MainMenu(Window *parent,int x,int y,int w)
         :AutoMenu(parent,MainMenuRes,2,x,y,w)
         {};

   protected:

      void CmFileOpen();
      void CmFileShellToDos();
      void CmFileExit();

      void CmHelpContents();

      DECLARE_RESPONSE_TABLE;
};

class MainMenuWindow:public Window {
   public:
      MainMenuWindow()
         :Window(NULL,NULL,0,0,ws.GetTopWindow()->GetWidth()-1,SysFont->height+FWIDTH*2+4,WA_VISABLE | WA_BORDER)
      {
         menu=new MainMenu(this,FWIDTH+2,FWIDTH+2,w-FWIDTH*2-5);
      }
      ~MainMenuWindow()
         {delete menu;}

   private:
      MainMenu *menu;
};

#endif
