/* -*- coding: cp852 -*-

  DJGPP Socket Wrapper for Microsoft Network Client  
  written by Tomasz Zbroek (2007/2008) / UPOS System Sp. z o.o.
  Released to the Public Domain.

*/

#ifndef _LOCATER_H_
#define _LOCATER_H_

#include "bastypes.h"

enum ECmd
  {
    eCmd_Accept = 0,
    eCmd_Bind = 0x01,
    eCmd_Close = 0x02,
    eCmd_Exit = 0x03,
    eCmd_Connect = 0x04,
    eCmd_GetHostName = 0x05,
    eCmd_Ioctl = 0x09,
    eCmd_Listen = 0x0a,
    eCmd_Recv = 0x0b,
    eCmd_Select = 0x0c,
    eCmd_Send = 0x0d,
    eCmd_Socket = 0x10,
    eCmd_GetStatus = 0x12
  };

struct SCommand
{
  byte yCmd; // command code (ECmd)

  // address for result
  word wResOffset; 
  word wResSegment;

  // address for errno
  word wErrOffset;
  word wErrSegment;

  // I set this to 0, but in original it is set with cs register
  word wCodeSegment; 

  // command parameters
  word wParam1;
  word wParam2;
  word wParam3;
  word wParam4;
  word wParam5;
  word wParam6;
  word wParam7;
  word wParam8;
  union
  {
    byte yParam9;
    word wParam9;
  };
  word yParam10;

  // tmp
  byte aReserved[4];
} __attribute__ ((packed));

struct SDriver
{
  byte yField0;
  byte yField1;
  word wField2;
  dword dwField3; /* address of procedure to run in MSClient*/
  dword dwField4;
  dword dwField5;
  dword dwField6;
  word wField7;
  dword dwField8;
} __attribute__ ((packed));

bool LocaterOpen();
bool LocaterClose();
bool LocaterBind(const char *i_pName, dword *o_pProcAddr, word *o_pResult);
bool LocaterUnbind(const char *i_pName, word *o_pResult);
int LocaterSend(struct SCommand *pCmd, word *o_pErrNo);

#endif
