/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: _jpsjprp.c,v 1.2 1996/10/27 13:23:45 jack Exp $ */

#include <wctype.h>
#include <wcprvt.h>

#define WC(x) ((wchar_t) (x))
#define WCNODIFF (WC (0U))
#define WCRANGE (0)
#define WCCLASSEND { -1, (wchar_t *) 0 }
#define DIFFOF(a,b) (WC ((int)(a) - (int)(b)))
#define NUMOF(x) (sizeof ((x)) / sizeof (*(x)))

/* classifications (ja_JP.SJIS locale) */
static wchar_t __wcrange_ja_jp_sjis_cntrl[] = { WC (0x0000U), WC (0x001fU), WCNODIFF, };
static wchar_t __wcrange_ja_jp_sjis_digit[] = { WC ('0'), WC ('9'), WCNODIFF, };
static wchar_t __wcrange_ja_jp_sjis_upper[] = { WC ('A'), WC ('Z'), DIFFOF ('a', 'A'), };
static wchar_t __wcrange_ja_jp_sjis_lower[] = { WC ('a'), WC ('z'), DIFFOF ('A', 'a'), };
static wchar_t __wcrange_ja_jp_sjis_hexupr[] = { WC ('A'), WC ('F'), DIFFOF ('a', 'A'), };
static wchar_t __wcrange_ja_jp_sjis_hexlwr[] = { WC ('a'), WC ('f'), DIFFOF ('A', 'a'), };
static wchar_t __wcenum_ja_jp_sjis_space[] =
{
  WC ('\t'), WC ('\n'), WC('\v'), WC ('\f'), WC ('\r'), WC (' '), WC (0x3000U),
};
static wchar_t __wcenum_ja_jp_sjis_punct[] =
{
  WC ('!'), WC ('"'), WC ('#'), WC ('$'), WC ('%'), WC ('&'), WC ('\''),
  WC ('('), WC (')'), WC ('*'), WC ('+'), WC (','), WC ('-'), WC ('.'),
  WC ('/'), WC (':'), WC (';'), WC ('<'), WC ('='), WC ('>'), WC ('?'),
  WC ('@'), WC ('['), WC ('\\'), WC (']'), WC ('^'), WC ('_'), WC ('`'),
  WC ('{'), WC ('|'), WC ('}'), WC ('~'),
#if 0
  WC (0x005cU), /* REVERSE SOLIDUS */
#endif
  WC (0x00a2U), /* CENT SIGN */
  WC (0x00a3U), /* POUND SIGN */
  WC (0x00a5U), /* YEN SIGN */
  WC (0x00a7U), /* SECTION SIGN */
  WC (0x00a8U), /* DIAERESIS */
  WC (0x00acU), /* NOT SIGN */
  WC (0x00b0U), /* DEGREE SIGN */
  WC (0x00b1U), /* PLUS-MINUS SIGN */
  WC (0x00b4U), /* ACUTE ACCENT */
  WC (0x00b6U), /* PILCROW SIGN */
  WC (0x00d7U), /* MULTIPLICATION SIGN */
  WC (0x00f7U), /* DIVISION SIGN */
  WC (0x2010U), /* HYPHEN */
  WC (0x2015U), /* HORIZONTAL BAR */
  WC (0x2016U), /* DOUBLE VERTICAL LINE */
  WC (0x2018U), /* LEFT SINGLE QUOTATION MARK */
  WC (0x2019U), /* RIGHT SINGLE QUOTATION MARK */
  WC (0x201cU), /* LEFT DOUBLE QUOTATION MARK */
  WC (0x201dU), /* RIGHT DOUBLE QUOTATION MARK */
  WC (0x2020U), /* DAGGER */
  WC (0x2021U), /* DOUBLE DAGGER */
  WC (0x2025U), /* TWO DOT LEADER */
  WC (0x2026U), /* HORIZONTAL ELLIPSIS */
  WC (0x2030U), /* PER MILLE SIGN */
  WC (0x2032U), /* PRIME */
  WC (0x2033U), /* DOUBLE PRIME */
  WC (0x203bU), /* REFERENCE MARK */
  WC (0x203eU), /* OVERLINE */
  WC (0x2103U), /* DEGREE CELSIUS */
  WC (0x212bU), /* ANGSTROM SIGN */
  WC (0x2190U), /* LEFTWARDS ARROW */
  WC (0x2191U), /* UPWARDS ARROW */
  WC (0x2192U), /* RIGHTWARDS ARROW */
  WC (0x2193U), /* DOWNWARDS ARROW */
  WC (0x21d2U), /* RIGHTWARDS DOUBLE ARROW */
  WC (0x21d4U), /* LEFT RIGHT DOUBLE ARROW */
  WC (0x2200U), /* FOR ALL */
  WC (0x2202U), /* PARTIAL DIFFERENTIAL */
  WC (0x2203U), /* THERE EXISTS */
  WC (0x2207U), /* NABLA */
  WC (0x2208U), /* ELEMENT OF */
  WC (0x220bU), /* CONTAINS AS MEMBER */
  WC (0x2212U), /* MINUS SIGN */
  WC (0x221aU), /* SQUARE ROOT */
  WC (0x221dU), /* PROPORTIONAL TO */
  WC (0x221eU), /* INFINITY */
  WC (0x2220U), /* ANGLE */
  WC (0x2227U), /* LOGICAL AND */
  WC (0x2228U), /* LOGICAL OR */
  WC (0x2229U), /* INTERSECTION */
  WC (0x222aU), /* UNION */
  WC (0x222bU), /* INTEGRAL */
  WC (0x222cU), /* DOUBLE INTEGRAL */
  WC (0x2234U), /* THEREFORE */
  WC (0x2235U), /* BECAUSE */
  WC (0x223dU), /* REVERSED TILDE */
  WC (0x2252U), /* APPROXIMATELY EQUAL TO OR THE IMAGE OF */
  WC (0x2260U), /* NOT EQUAL TO */
  WC (0x2261U), /* IDENTICAL TO */
  WC (0x2266U), /* LESS-THAN OVER EQUAL TO */
  WC (0x2267U), /* GREATER-THAN OVER EQUAL TO */
  WC (0x226aU), /* MUCH LESS-THAN */
  WC (0x226bU), /* MUCH GREATER-THAN */
  WC (0x2282U), /* SUBSET OF */
  WC (0x2283U), /* SUPERSET OF */
  WC (0x2286U), /* SUBSET OF OR EQUAL TO */
  WC (0x2287U), /* SUPERSET OF OR EQUAL TO */
  WC (0x22a5U), /* UP TACK */
  WC (0x2312U), /* ARC */
  WC (0x2500U), /* BOX DRAWINGS LIGHT HORIZONTAL */
  WC (0x2501U), /* BOX DRAWINGS HEAVY HORIZONTAL */
  WC (0x2502U), /* BOX DRAWINGS LIGHT VERTICAL */
  WC (0x2503U), /* BOX DRAWINGS HEAVY VERTICAL */
  WC (0x250cU), /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
  WC (0x250fU), /* BOX DRAWINGS HEAVY DOWN AND RIGHT */
  WC (0x2510U), /* BOX DRAWINGS LIGHT DOWN AND LEFT */
  WC (0x2513U), /* BOX DRAWINGS HEAVY DOWN AND LEFT */
  WC (0x2514U), /* BOX DRAWINGS LIGHT UP AND RIGHT */
  WC (0x2517U), /* BOX DRAWINGS HEAVY UP AND RIGHT */
  WC (0x2518U), /* BOX DRAWINGS LIGHT UP AND LEFT */
  WC (0x251bU), /* BOX DRAWINGS HEAVY UP AND LEFT */
  WC (0x251cU), /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
  WC (0x251dU), /* BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY */
  WC (0x2520U), /* BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT */
  WC (0x2523U), /* BOX DRAWINGS HEAVY VERTICAL AND RIGHT */
  WC (0x2524U), /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
  WC (0x2525U), /* BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY */
  WC (0x2528U), /* BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT */
  WC (0x252bU), /* BOX DRAWINGS HEAVY VERTICAL AND LEFT */
  WC (0x252cU), /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
  WC (0x252fU), /* BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY */
  WC (0x2530U), /* BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT */
  WC (0x2533U), /* BOX DRAWINGS HEAVY DOWN AND HORIZONTAL */
  WC (0x2534U), /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
  WC (0x2537U), /* BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY */
  WC (0x2538U), /* BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT */
  WC (0x253bU), /* BOX DRAWINGS HEAVY UP AND HORIZONTAL */
  WC (0x253cU), /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
  WC (0x253fU), /* BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY */
  WC (0x2542U), /* BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT */
  WC (0x254bU), /* BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL */
  WC (0x25a0U), /* BLACK SQUARE */
  WC (0x25a1U), /* WHITE SQUARE */
  WC (0x25b2U), /* BLACK UP-POINTING TRIANGLE */
  WC (0x25b3U), /* WHITE UP-POINTING TRIANGLE */
  WC (0x25bcU), /* BLACK DOWN-POINTING TRIANGLE */
  WC (0x25bdU), /* WHITE DOWN-POINTING TRIANGLE */
  WC (0x25c6U), /* BLACK DIAMOND */
  WC (0x25c7U), /* WHITE DIAMOND */
  WC (0x25cbU), /* WHITE CIRCLE */
  WC (0x25ceU), /* BULLSEYE */
  WC (0x25cfU), /* BLACK CIRCLE */
  WC (0x25efU), /* LARGE CIRCLE */
  WC (0x2605U), /* BLACK STAR */
  WC (0x2606U), /* WHITE STAR */
  WC (0x2640U), /* FEMALE SIGN */
  WC (0x2642U), /* MALE SIGN */
  WC (0x266aU), /* EIGHTH NOTE */
  WC (0x266dU), /* MUSIC FLAT SIGN */
  WC (0x266fU), /* MUSIC SHARP SIGN */
  WC (0x3001U), /* IDEOGRAPHIC COMMA */
  WC (0x3002U), /* IDEOGRAPHIC FULL STOP */
  WC (0x3003U), /* DITTO MARK */
  WC (0x3005U), /* IDEOGRAPHIC ITERATION MARK */
  WC (0x3006U), /* IDEOGRAPHIC CLOSING MARK */
  WC (0x3007U), /* IDEOGRAPHIC NUMBER ZERO */
  WC (0x3008U), /* LEFT ANGLE BRACKET */
  WC (0x3009U), /* RIGHT ANGLE BRACKET */
  WC (0x300aU), /* LEFT DOUBLE ANGLE BRACKET */
  WC (0x300bU), /* RIGHT DOUBLE ANGLE BRACKET */
  WC (0x300cU), /* LEFT CORNER BRACKET */
  WC (0x300dU), /* RIGHT CORNER BRACKET */
  WC (0x300eU), /* LEFT WHITE CORNER BRACKET */
  WC (0x300fU), /* RIGHT WHITE CORNER BRACKET */
  WC (0x3010U), /* LEFT BLACK LENTICULAR BRACKET */
  WC (0x3011U), /* RIGHT BLACK LENTICULAR BRACKET */
  WC (0x3012U), /* POSTAL MARK */
  WC (0x3013U), /* GETA MARK */
  WC (0x3014U), /* LEFT TORTOISE SHELL BRACKET */
  WC (0x3015U), /* RIGHT TORTOISE SHELL BRACKET */
  WC (0x301cU), /* WAVE DASH */
  WC (0x309bU), /* KATAKANA-HIRAGANA VOICED SOUND MARK */
  WC (0x309cU), /* KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK */
  WC (0x309dU), /* HIRAGANA ITERATION MARK */
  WC (0x309eU), /* HIRAGANA VOICED ITERATION MARK */
  WC (0x30fbU), /* KATAKANA MIDDLE DOT */
  WC (0x30fcU), /* KATAKANA-HIRAGANA PROLONGED SOUND MARK */
  WC (0x30fdU), /* KATAKANA ITERATION MARK */
  WC (0x30feU), /* KATAKANA VOICED ITERATION MARK */
  WC (0x4eddU), /* <CJK> */
  WC (0xff01U), /* FULLWIDTH EXCLAMATION MARK */
  WC (0xff03U), /* FULLWIDTH NUMBER SIGN */
  WC (0xff04U), /* FULLWIDTH DOLLAR SIGN */
  WC (0xff05U), /* FULLWIDTH PERCENT SIGN */
  WC (0xff06U), /* FULLWIDTH AMPERSAND */
  WC (0xff08U), /* FULLWIDTH LEFT PARENTHESIS */
  WC (0xff09U), /* FULLWIDTH RIGHT PARENTHESIS */
  WC (0xff0aU), /* FULLWIDTH ASTERISK */
  WC (0xff0bU), /* FULLWIDTH PLUS SIGN */
  WC (0xff0cU), /* FULLWIDTH COMMA */
  WC (0xff0eU), /* FULLWIDTH FULL STOP */
  WC (0xff0fU), /* FULLWIDTH SOLIDUS */
  WC (0xff1aU), /* FULLWIDTH COLON */
  WC (0xff1bU), /* FULLWIDTH SEMICOLON */
  WC (0xff1cU), /* FULLWIDTH LESS-THAN SIGN */
  WC (0xff1dU), /* FULLWIDTH EQUALS SIGN */
  WC (0xff1eU), /* FULLWIDTH GREATER-THAN SIGN */
  WC (0xff1fU), /* FULLWIDTH QUESTION MARK */
  WC (0xff20U), /* FULLWIDTH COMMERCIAL AT */
  WC (0xff3bU), /* FULLWIDTH LEFT SQUARE BRACKET */
  WC (0xff3dU), /* FULLWIDTH RIGHT SQUARE BRACKET */
  WC (0xff3eU), /* FULLWIDTH CIRCUMFLEX ACCENT */
  WC (0xff3fU), /* FULLWIDTH LOW LINE */
  WC (0xff40U), /* FULLWIDTH GRAVE ACCENT */
  WC (0xff5bU), /* FULLWIDTH LEFT CURLY BRACKET */
  WC (0xff5cU), /* FULLWIDTH VERTICAL LINE */
  WC (0xff5dU), /* FULLWIDTH RIGHT CURLY BRACKET */
  WC (0xffe3U), /* FULLWIDTH MACRON */
  WC (0xffe5U), /* FULLWIDTH YEN SIGN */
};

/* FULLWIDTH DIGIT ZERO - NINE */
static wchar_t __wcrange_ja_jp_sjis_fdigit[] =
{
  WC (0xff10U), WC (0xff19U), WCNODIFF,
};

/* FULLWIDTH LATIN CAPITAL LETTER A - Z */
static wchar_t __wcrange_ja_jp_sjis_fupper[] =
{
  WC (0xff21U), WC (0xff3aU), DIFFOF (0xff41U, 0xff21U),
};

/* FULLWIDTH LATIN SMALL LETTER A - Z */
static wchar_t __wcrange_ja_jp_sjis_flower[] =
{
  WC (0xff41U), WC (0xff5aU), DIFFOF (0xff21U, 0xff41U),
};

/* FULLWIDTH LATIN CAPITAL LETTER A - F */
static wchar_t __wcrange_ja_jp_sjis_fhexupr[] =
{
  WC (0xff21U), WC (0xff26U), DIFFOF (0xff41U, 0xff21U),
};

/* FULLWIDTH LATIN SMALL LETTER A - F */
static wchar_t __wcrange_ja_jp_sjis_fhexlwr[] =
{
  WC (0xff41U), WC (0xff46U), DIFFOF (0xff21U, 0xff41U),
};

/* GREEK CAPITAL LETTER ALPHA - OMEGA */
static wchar_t __wcrange_ja_jp_sjis_fgupper[] =
{
  WC (0x0391U), WC (0x03a9U), DIFFOF (0x03b1U, 0x0391U),
};

/* GREEK SMALL LETTER ALPHA - OMEGA */
static wchar_t __wcrange_ja_jp_sjis_fglower[] =
{
  WC (0x03b1U), WC (0x03c9U), DIFFOF (0x0391U, 0x03b1U),
};

/* CYRILLIC CAPITAL LETTER A - YA */
static wchar_t __wcrange_ja_jp_sjis_fcupper1[] =
{
  WC (0x0410U), WC (0x042fU), DIFFOF (0x0430U, 0x0410U),
};

/* CYRILLIC CAPITAL LETTER IO */
static wchar_t __wcrange_ja_jp_sjis_fcupper2[] =
{
  WC (0x0401U), WC (0x0401U), DIFFOF (0x0451U, 0x0401U),
};

/* CYRILLIC SMALL LETTER A - YA */
static wchar_t __wcrange_ja_jp_sjis_fclower1[] =
{
  WC (0x0430U), WC (0x044fU), DIFFOF (0x0410U, 0x0430U),
};

/* CYRILLIC SMALL LETTER IO */
static wchar_t __wcrange_ja_jp_sjis_fclower2[] =
{
  WC (0x0451U), WC (0x0451U), DIFFOF (0x0401U, 0x0451U),
};

/* HIRAGANA LETTER SMALL A - HIRAGANA LETTER N */
static wchar_t __wcrange_ja_jp_sjis_fhiragana[] =
{
  WC (0x3041U), WC (0x3093U), DIFFOF (0x30a1U, 0x3041U),
};

/* KATAKANA LETTER SMALL A - KATAKANA LETTER N */
static wchar_t __wcrange_ja_jp_sjis_fkatakana1[] =
{
  WC (0x30a1U), WC (0x30f3U), DIFFOF (0x3041U, 0x30a1U),
};

/* KATAKANA LETTER VU - KATAKANA LETTER SMALL KE */
static wchar_t __wcrange_ja_jp_sjis_fkatakana2[] =
{
  WC (0x30f4U), WC (0x30f6U), WCNODIFF,
};

static struct __wcclass __wcclass_ja_jp_sjis_alnum[] =
{
  { WCRANGE, &__wcrange_ja_jp_sjis_digit[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fdigit[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_upper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fupper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_lower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_flower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fgupper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fglower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fcupper1[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fcupper2[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fclower1[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fclower2[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_ja_jp_sjis_alpha[] =
{
  { WCRANGE, &__wcrange_ja_jp_sjis_upper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fupper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_lower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_flower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fgupper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fglower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fcupper1[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fcupper2[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fclower1[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fclower2[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_ja_jp_sjis_cntrl[] =
{
  { WCRANGE, &__wcrange_ja_jp_sjis_cntrl[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_ja_jp_sjis_digit[] =
{
  { WCRANGE, &__wcrange_ja_jp_sjis_digit[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fdigit[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_ja_jp_sjis_graph[] =
{
  { WCRANGE, &__wcrange_ja_jp_sjis_digit[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fdigit[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_upper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fupper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_lower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_flower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fgupper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fglower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fcupper1[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fcupper2[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fclower1[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fclower2[0] },
  { NUMOF (__wcenum_ja_jp_sjis_punct), &__wcenum_ja_jp_sjis_punct[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_ja_jp_sjis_lower[] =
{
  { WCRANGE, &__wcrange_ja_jp_sjis_lower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_flower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fglower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fclower1[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fclower2[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_ja_jp_sjis_print[] =
{
  { WCRANGE, &__wcrange_ja_jp_sjis_digit[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fdigit[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_upper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fupper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_lower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_flower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fgupper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fglower[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fcupper1[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fcupper2[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fclower1[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fclower2[0] },
  { NUMOF (__wcenum_ja_jp_sjis_space), &__wcenum_ja_jp_sjis_space[0] },
  { NUMOF (__wcenum_ja_jp_sjis_punct), &__wcenum_ja_jp_sjis_punct[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_ja_jp_sjis_punct[] =
{
  { NUMOF (__wcenum_ja_jp_sjis_punct), &__wcenum_ja_jp_sjis_punct[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_ja_jp_sjis_space[] =
{
  { NUMOF (__wcenum_ja_jp_sjis_space), &__wcenum_ja_jp_sjis_space[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_ja_jp_sjis_upper[] =
{
  { WCRANGE, &__wcrange_ja_jp_sjis_upper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fupper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fgupper[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fcupper1[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fcupper2[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_ja_jp_sjis_xdigit[] =
{
  { WCRANGE, &__wcrange_ja_jp_sjis_digit[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fdigit[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_hexupr[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fhexupr[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_hexlwr[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fhexlwr[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_ja_jp_sjis_hiragana[] =
{
  { WCRANGE, &__wcrange_ja_jp_sjis_fhiragana[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_ja_jp_sjis_katakana[] =
{
  { WCRANGE, &__wcrange_ja_jp_sjis_fkatakana1[0] },
  { WCRANGE, &__wcrange_ja_jp_sjis_fkatakana2[0] },
  WCCLASSEND,
};

/* properties (ja_JP.SJIS locale) */
static struct __wcprop __wcprop_ja_jp_sjis_alnum =
{
  "alnum",
  &__wcclass_ja_jp_sjis_alnum[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_alpha =
{
  "alpha",
  &__wcclass_ja_jp_sjis_alpha[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_cntrl =
{
  "cntrl",
  &__wcclass_ja_jp_sjis_cntrl[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_digit =
{
  "digit",
  &__wcclass_ja_jp_sjis_digit[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_graph =
{
  "graph",
  &__wcclass_ja_jp_sjis_graph[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_lower =
{
  "lower",
  &__wcclass_ja_jp_sjis_lower[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_print =
{
  "print",
  &__wcclass_ja_jp_sjis_print[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_punct =
{
  "punct",
  &__wcclass_ja_jp_sjis_punct[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_space =
{
  "space",
  &__wcclass_ja_jp_sjis_space[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_upper =
{
  "upper",
  &__wcclass_ja_jp_sjis_upper[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_xdigit =
{
  "xdigit",
  &__wcclass_ja_jp_sjis_xdigit[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_hiragana =
{
  "hiragana",
  &__wcclass_ja_jp_sjis_hiragana[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_katakana =
{
  "katakana",
  &__wcclass_ja_jp_sjis_katakana[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_tolower =
{
  "tolower",
  &__wcclass_ja_jp_sjis_upper[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_toupper =
{
  "toupper",
  &__wcclass_ja_jp_sjis_lower[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_tohiragana =
{
  "hiragana",
  &__wcclass_ja_jp_sjis_katakana[0],
};

static struct __wcprop __wcprop_ja_jp_sjis_tokatakana =
{
  "tokatakana",
  &__wcclass_ja_jp_sjis_hiragana[0],
};

/* array of property pointers sorted by name (ja_JP.SJIS locale) */
struct __wcprop *__wcprops_ja_jp_sjis[] =
{
  &__wcprop_ja_jp_sjis_alnum,
  &__wcprop_ja_jp_sjis_alpha,
  &__wcprop_ja_jp_sjis_cntrl,
  &__wcprop_ja_jp_sjis_digit,
  &__wcprop_ja_jp_sjis_graph,
  &__wcprop_ja_jp_sjis_hiragana,
  &__wcprop_ja_jp_sjis_katakana,
  &__wcprop_ja_jp_sjis_lower,
  &__wcprop_ja_jp_sjis_print,
  &__wcprop_ja_jp_sjis_punct,
  &__wcprop_ja_jp_sjis_space,
  &__wcprop_ja_jp_sjis_upper,
  &__wcprop_ja_jp_sjis_xdigit,
};

struct __wcprop *__wcprops_trans_ja_jp_sjis[] =
{
  &__wcprop_ja_jp_sjis_tohiragana,
  &__wcprop_ja_jp_sjis_tokatakana,
  &__wcprop_ja_jp_sjis_tolower,
  &__wcprop_ja_jp_sjis_toupper,
};

/* maximum number of index (ja_JP.SJIS locale) */
int __wcprops_ja_jp_sjis_num = NUMOF (__wcprops_ja_jp_sjis);
int __wcprops_trans_ja_jp_sjis_num = NUMOF (__wcprops_trans_ja_jp_sjis);
