/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbsrev.c,v 1.1 1996/07/01 19:16:18 jack Exp $ */

#include <stddef.h>
#include <mbstring.h>

unsigned char *
_mbsrev (unsigned char *us)
{
  unsigned char *top = us;
  unsigned char *ul, *ur;
  unsigned char uc;
  size_t bytes, total = 0;
  size_t loop;

  /* reverse multibyte */
  while (1)
    {
      bytes = _mbclen (us);
      if (bytes == 1)
	{
	  if (*us == '\0')
	    break;
	}
      else
	{
	  ul = us;
	  ur = us + bytes - 1;
	  loop = (bytes + 1) >> 1;
	  while (loop-- > 0)
	    {
	      uc = *ul;
	      *ul++ = *ur;
	      *ur-- = uc;
	    }
	}
      us += bytes;
      total += bytes;
    }

  /* reverse all */
  ul = top;
  ur = top + total - 1;
  loop = (total + 1) >> 1;
  while (loop-- > 0)
    {
      uc = *ul;
      *ul++ = *ur;
      *ur-- = uc;
    }

  return top;
}
