/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbccmp.c,v 1.1 1996/06/30 13:25:00 jack Exp $ */

#include <mbctype.h>
#include <mbstring.h>

int
_mbccmp (const unsigned char *us1, const unsigned char *us2)
{
  int c1, c2;

  c1 = *us1++;
  if (_ismbblead (c1) && *us1 != '\0')
    c1 = (c1 << 8) + *us1;
  c2 = *us2++;
  if (_ismbblead (c2) && *us2 != '\0')
    c2 = (c2 << 8) + *us2;
  return c1 - c2;
}
