/**
 * $Id: testprim.cc,v 1.3 1996/12/07 01:22:44 keithw Exp $
 *
 * (c)1996 Hermetica. Written by Alligator Descartes <descarte@hermetica.com>
 *
 * Tests tesselation libraries
 *
 * $Log: testprim.cc,v $
 * Revision 1.3  1996/12/07 01:22:44  keithw
 * 0.1.8 beta 3
 *
 * Revision 1.2  1996/11/01 07:47:48  keithw
 * Texturemapping, subpixel positioning.
 *
// Revision 1.1  1996/08/31  07:02:55  keithw
// Autoconf support
//
 */

#include <stdio.h>

#include <Lib3d/Viewport.H>
#include <Lib3d/Model.H>
#include <Lib3d/ModelBuilder.H>
#include <Lib3d/World.H>
#include <Lib3d/Camera.H>
#include <Lib3d/Light.H>
#include <Lib3d/internals/HrTimer.H>
#include <Lib3d/Pipeline.H>
#include <Lib3d/SmoothPipeline.H>
#include <Lib3d/FlatPipeline.H>
#include <Lib3d/WirePipeline.H>
#include <Primitive/Primitive.H>
#include <iostream.h>
#include <fstream.h>

// static const char *rcsId = "$Id";

main() {

    World world;
    Viewport *viewport = Viewport::create( Device::create( 320, 200, 8 ) );
    if (!viewport) {
	cout << "Failed to create viewport" << endl;
	exit(1);
    }

    Model *shade = createCylinder( TRIANGULAR, CAP_NONE, 5, 25, 15, 10 );
    Model *stem = createCylinder( TRIANGULAR, CAP_BOTH, 3, 50, 8 );
    Model *base = createCylinder( TRIANGULAR, CAP_BOTH, 10, 4, 20 );

    Model *leg1 = createCube( TRIANGULAR, FACE_OUTSIDE, 5, 20, 5 );
    Model *leg2 = createCube( TRIANGULAR, FACE_OUTSIDE, 5, 20, 5 );
    Model *leg3 = createCube( TRIANGULAR, FACE_OUTSIDE, 5, 20, 5 );
    Model *leg4 = createCube( TRIANGULAR, FACE_OUTSIDE, 5, 20, 5 );
    Model *tabletop = createCylinder( TRIANGULAR, CAP_BOTH, 20, 3, 20 );

    Model *sphere = createSphere( LONGITUDINAL, POLYGONAL, FACE_BOTH, 20, 18 );

    Model *cone = createCone( CAP_NONE, 5, 10, 10 );
    cout << *leg1 << endl;

    printf( "exited create_cylicone()\n" );
    if ( shade == NULL ) {
        printf( "Model is NULL\n" );
        exit( 333 );
      }
    world.adopt( shade );
    world.adopt( stem );
    world.adopt( base );

    world.adopt( leg1 );
    world.adopt( leg2 );
    world.adopt( leg3 );
    world.adopt( leg4 );
    world.adopt( tabletop );

    world.adopt( sphere );
    world.adopt( cone );

    Camera *camera = new Camera( world );
    camera->setParameters( 3, 1000, 15, 1 );
    world.setActiveCamera( *camera );

    Vector3 colour(1,1,1);      // A white light
    Vector3 direction(0,1,.5);
    Light *light = new Light(world);
    light->setParameters(colour, colour, direction);
    world.registerLight( *light );

//    Pipeline *smoothpipe = new SmoothPipeline;
//    sphere->usePipeline( *smoothpipe );

    Matrix34 shade1, stem1, base1;
    Matrix34 leg11, leg21, leg31, leg41, tabletop1;
    Matrix34 sphere1, cone1, cone2;
    Matrix34 cam;
    Matrix34 modRot, sphereRot;

    cam.setTranslation( 0, 10, -250 );

    shade1.setIdentity();
    shade1.setTranslation( 10, 0, 0 );
    stem1.setTranslation( 10, 5, 0 );
    base1.setTranslation( 10, 55, 0 );

    leg11.setTranslation( -15, 31, 15 );
    leg21.setTranslation( -30, 31, 15 );
    leg31.setTranslation( -15, 31, 0 );
    leg41.setTranslation( -30, 31, 0 );
    tabletop1.setTranslation( -22, 28, 7 );

    sphere1.setTranslation( 30, -30, 0 );
    sphereRot.setRotation( -3.14, 1, 1, 1 );
    cone1.setTranslation( -22, 28, 7 );
    cone2.setRotation( 180, 1, 0, 0 );
    cone1.postmul( cone2 );
    
    camera->setTransform( cam );

    modRot.setRotation( 3.14, 1, 1, 0 );

    for ( int i = 0 ; i < 1200 ; i++ ) {
        shade1.premul( modRot );
        stem1.premul( modRot );
        base1.premul( modRot );
        leg11.premul( modRot );
        leg21.premul( modRot );
        leg31.premul( modRot );
        leg41.premul( modRot );
        tabletop1.premul( modRot );
        sphere1.postmul( sphereRot );
        sphere1.premul( modRot );
        cone1.premul( modRot );

        shade->setTransform( shade1 );
        stem->setTransform( stem1 );
        base->setTransform( base1 );
        leg1->setTransform( leg11 );
        leg2->setTransform( leg21 );
        leg3->setTransform( leg31 );
        leg4->setTransform( leg41 );
        tabletop->setTransform( tabletop1 );
        sphere->setTransform( sphere1 );
        cone->setTransform( cone1 );

        world.renderHierarchy( *viewport );
        viewport->swapBuffers();
      }
  }
