#include <Lib3d/Vector.H>
#include <Lib3d/Matrix.H>
#include <iostream.h>

main()
{
    Matrix4 a;
    Matrix4 b;

    a.setIdentity();
    b.setIdentity();
    cout << "Identity: " << a << endl;
    
    Matrix34 a34;
    a34.setIdentity();
    cout << "34 Identity: " << a34 << endl;

    a.setTranslation(160, 100, 0);
    cout << "a.setTranslation(160, 100, 0) :" << a << endl;
    
    b.setScale(160,100,10000);
    cout << "b.setScale(160,100,10000) : " << b << endl;

    Matrix4 c;
    c.mul(a , b);
    cout << "c = a * b : " << c << endl;

   
    Matrix4 d;

    d.setIdentity();
    d.translate(160,100,0);
    d.scale(160,100,10000);
    cout << "d.id.trx.scale = " << d << endl;

    d = a;
    cout << "d = a : " << d << endl;

    d.premul(b);
    cout << "d = b * d : " << d << endl; 
/*
    d.setTranslation(0,-80,0);
    cout << "d.setTranslation(0,-80,0) : " << d << endl;
*/

    d.v[0][3] = 100;
    cout << "d.v[0][3] = 100: " << d << endl; 

    d.v[3][0] = 20;
    cout << "d.v[3][0] = 20: " << d << endl; 

    Matrix4 e;
    e.invert(d);
    cout << "e = inv(d) : " << e << endl; 

    e.premul(d);
    cout << "e = d * inv(d) : " << e << endl; 

    Vector4 i(1,1,1);
    cout << "i = [1,1,1 | 1] : " << i << endl;

    Vector4 j;
    j.mul(a, i);
    cout << "j = a * i : " << j << endl;

    Vector4 k;
    k.mul(b, j);
    cout << "k = b * j : " << k << endl;

    k.mul(c, i);
    cout << "k = c * i : " << k << endl;

    a.setPerspective(.1, 10, 5);
    cout << "a.setPerspective(.5, 10, 5) : " << a << endl;

    Vector4 l;
    l.mul(a, i);
    cout << "l = a * i : " << l << endl;

    l.mul(a, j);
    cout << "l = a * j : " << l << endl;

    l.mul(a, k);
    cout << "l = a * k : " << l << endl;

    Vector4 test(2,2,2);
    l.mul(a, test);
    cout << "l = a * " << test << " : " << l << endl;
    test.assign(-2,-2,-2,-1);
    l.mul(a, test);
    cout << "l = a * " << test << " : " << l << endl;
    test.assign(2,2,2,-1);
    l.mul(a, test);
    cout << "l = a * " << test << " : " << l << endl;
    test.assign(-2,-2,-2,1);
    l.mul(a, test);
    cout << "l = a * " << test << " : " << l << endl;
    
    c.mul(a,b);
    cout << "c = a * b : " << c << endl;
    l.mul(a, i);
    cout << "l = a * i : " << l << endl;

    l.mul(a, k);
    cout << "l = a * k : " << l << endl;


}







