@echo off
echo Configuring Free Lossless Audio Codec Library 1.3.4 for DJGPP v2.5...

Rem WARNING WARNING WARNING: This file needs to have DOS CRLF end-of-line
Rem format, or else stock DOS/Windows shells will refuse to run it.

Rem The SmallEnv tests protect against fixed and too small size
Rem of the environment in stock DOS shell.

Rem Find out if NLS is wanted or not,
Rem if dependency-tracking is wanted or not,
Rem if caching is wanted or not
Rem and where the sources are.
Rem We always default to NLS support,
Rem no dependency tracking
Rem and to in place configuration.
set ARGS=
set NLS=enabled
if not "%NLS%" == "enabled" goto SmallEnv
set CACHING=enabled
if not "%CACHING%" == "enabled" goto SmallEnv
set DEPENDENCY_TRACKING=disabled
if not "%DEPENDENCY_TRACKING%" == "disabled" goto SmallEnv
set LIBICONV_PREFIX=disabled
if not "%LIBICONV_PREFIX%" == "disabled" goto SmallEnv
set LIBINTL_PREFIX=disabled
if not "%LIBINTL_PREFIX%" == "disabled" goto SmallEnv
set HTML=enabled
if not "%HTML%" == "enabled" goto SmallEnv
set SILENT=enabled
if not "%SILENT%" == "enabled" goto SmallEnv
set FLAC++=enabled
if not "%FLAC++%" == "enabled" goto SmallEnv
set ASM=disabled
if not "%ASM%" == "disabled" goto SmallEnv
set SSE=disabled
if not "%SSE%" == "disabled" goto SmallEnv
set XSRC=.
if not "%XSRC%" == "." goto SmallEnv

Rem Loop over all arguments.
Rem Special arguments are: NLS, XSRC, CACHE, STATIC_LIBS, LIBICONV_PREFIX, LIBINTL_PREFIX and DEPS.
Rem All other arguments are stored into ARGS.
:ArgLoop
if "%1" == "nls" goto NextArgument
if "%1" == "NLS" goto NextArgument
if "%1" == "no-nls" goto NoNLS
if "%1" == "no-NLS" goto NoNLS
if "%1" == "NO-NLS" goto NoNLS
goto CachingOption
:NoNLS
if "%1" == "no-nls" set NLS=disabled
if "%1" == "no-NLS" set NLS=disabled
if "%1" == "NO-NLS" set NLS=disabled
if not "%NLS%" == "disabled" goto SmallEnv
goto NextArgument
:CachingOption
if "%1" == "cache" goto NextArgument
if "%1" == "CACHE" goto NextArgument
if "%1" == "no-cache" goto NoCaching
if "%1" == "no-CACHE" goto NoCaching
if "%1" == "NO-CACHE" goto NoCaching
goto DependencyOption
:NoCaching
if "%1" == "no-cache" set CACHING=disabled
if "%1" == "no-CACHE" set CACHING=disabled
if "%1" == "NO-CACHE" set CACHING=disabled
if not "%CACHING%" == "disabled" goto SmallEnv
goto NextArgument
:DependencyOption
if "%1" == "no-dep" goto NextArgument
if "%1" == "no-DEP" goto NextArgument
if "%1" == "NO-DEP" goto NextArgument
if "%1" == "dep" goto _DependencyTraking
if "%1" == "DEP" goto _DependencyTraking
goto LibiconvPrefixOption
:_DependencyTraking
if "%1" == "dep" set DEPENDENCY_TRACKING=enabled
if "%1" == "DEP" set DEPENDENCY_TRACKING=enabled
if not "%DEPENDENCY_TRACKING%" == "enabled" goto SmallEnv
goto NextArgument
:LibiconvPrefixOption
if "%1" == "no-libiconvprefix" goto NextArgument
if "%1" == "no-LIBICONVPREFIX" goto NextArgument
if "%1" == "NO-LIBICONVPREFIX" goto NextArgument
if "%1" == "libiconvprefix" goto WithLibiconvPrefix
if "%1" == "LIBICONVPREFIX" goto WithLibiconvPrefix
goto LibintlPrefixOption
:WithLibiconvPrefix
if "%1" == "libiconvprefix" set LIBICONV_PREFIX=enabled
if "%1" == "LIBICONVPREFIX" set LIBICONV_PREFIX=enabled
if not "%LIBICONV_PREFIX%" == "enabled" goto SmallEnv
goto NextArgument
:LibintlPrefixOption
if "%1" == "no-libintlprefix" goto NextArgument
if "%1" == "no-LIBINTLPREFIX" goto NextArgument
if "%1" == "NO-LIBINTLPREFIX" goto NextArgument
if "%1" == "libintlprefix" goto _WithLibintlPrefix
if "%1" == "LIBINTLPREFIX" goto _WithLibintlPrefix
goto HTMLOption
:_WithLibintlPrefix
if "%1" == "libintlprefix" set LIBINTL_PREFIX=enabled
if "%1" == "LIBINTLPREFIX" set LIBINTL_PREFIX=enabled
if not "%LIBINTL_PREFIX%" == "enabled" goto SmallEnv
:HTMLOption
if "%1" == "withhtml" goto NextArgument
if "%1" == "withHTML" goto NextArgument
if "%1" == "WITHHTML" goto NextArgument
if "%1" == "withouthtml" goto _WithoutHTML
if "%1" == "withoutHTML" goto _WithoutHTML
if "%1" == "WITHOUTHTML" goto _WithoutHTML
goto SilentOption
:_WithoutHTML
if "%1" == "withouthtml" set HTML=disabled
if "%1" == "withoutHTML" set HTML=disabled
if "%1" == "WITHOUTHTML" set HTML=disabled
if not "%HTML%" == "disabled" goto SmallEnv
goto NextArgument
:SilentOption
if "%1" == "silent" goto NextArgument
if "%1" == "SILENT" goto NextArgument
if "%1" == "no-silent" goto NoSILENT
if "%1" == "no-SILENT" goto NoSILENT
if "%1" == "NO-SILENT" goto NoSILENT
goto FlacxxOption
:NoSILENT
if "%1" == "no-silent" set SILENT=disabled
if "%1" == "no-SILENT" set SILENT=disabled
if "%1" == "NO-SILENT" set SILENT=disabled
if not "%SILENT%" == "disabled" goto SmallEnv
goto NextArgument
:FlacxxOption
if "%1" == "flac++" goto NextArgument
if "%1" == "FLAC++" goto NextArgument
if "%1" == "no-flac++" goto NoFLACXX
if "%1" == "no-FLAC++" goto NoFLACXX
if "%1" == "NO-FLAC++" goto NoFLACXX
goto AsmOption
:NoFLACXX
if "%1" == "no-flac++" set FLAC++=disabled
if "%1" == "no-FLAC++" set FLAC++=disabled
if "%1" == "NO-FLAC++" set FLAC++=disabled
if not "%FLAC++%" == "disabled" goto SmallEnv
goto NextArgument
:AsmOption
if "%1" == "no-asm" goto NextArgument
if "%1" == "no-ASM" goto NextArgument
if "%1" == "NO-ASM" goto NextArgument
if "%1" == "asm" goto _ASM
if "%1" == "Asm" goto _ASM
if "%1" == "ASM" goto _ASM
goto SseOption
:_ASM
if "%1" == "asm" set ASM=enabled
if "%1" == "Asm" set ASM=enabled
if "%1" == "ASM" set ASM=enabled
if not "%ASM%" == "enabled" goto SmallEnv
goto NextArgument
:SseOption
if "%1" == "no-sse" goto NextArgument
if "%1" == "no-SSE" goto NextArgument
if "%1" == "NO-SSE" goto NextArgument
if "%1" == "sse" goto _SSE
if "%1" == "Sse" goto _SSE
if "%1" == "SSE" goto _SSE
goto SrcDirOption
:_SSE
if "%1" == "sse" set SSE=enabled
if "%1" == "Sse" set SSE=enabled
if "%1" == "SSE" set SSE=enabled
if not "%SSE%" == "enabled" goto SmallEnv
goto NextArgument
:SrcDirOption
echo %1 | grep -q "/"
if errorlevel 1 goto CollectArgument
set XSRC=%1
if not "%XSRC%" == "%1" goto SmallEnv
goto NextArgument
:CollectArgument
set _ARGS=#%ARGS%#%1#
if not "%_ARGS%" == "#%ARGS%#%1#" goto SmallEnv
echo %_ARGS% | grep -q "###"
if errorlevel 1 set ARGS=%ARGS% %1
set _ARGS=
:NextArgument
shift
if not "%1" == "" goto ArgLoop

Rem Create an arguments file for the configure script.
echo --srcdir=%XSRC% > args
:if "%CACHING%" == "enabled"              echo --cache-file=%XSRC%/djgpp/config.cache >> args
if "%CACHING%" == "enabled"              echo --cache-file=./config.cache >> args
if "%DEPENDENCY_TRACKING%" == "enabled"  echo --enable-dependency-tracking >> args
if "%DEPENDENCY_TRACKING%" == "disabled" echo --disable-dependency-tracking >> args
if "%LIBICONV_PREFIX%" == "enabled"      echo --with-libiconv-prefix >> args
if "%LIBICONV_PREFIX%" == "disabled"     echo --without-libiconv-prefix >> args
if "%LIBINTL_PREFIX%" == "enabled"       echo --with-libintl-prefix >> args
if "%LIBINTL_PREFIX%" == "disabled"      echo --without-libintl-prefix >> args
if "%HTML%" == "enabled"                 echo --enable-html >> args
if "%HTML%" == "disabled"                echo --disable-html >> args
if "%SILENT%" == "enabled"               echo --enable-silent-rules >> args
if "%SILENT%" == "disabled"              echo --disable-silent-rules >> args
if "%FLAC++%" == "enabled"               echo --enable-cpplibs >> args
if "%FLAC++%" == "disabled"              echo --disable-cpplibs >> args
if "%ASM%" == "enabled"                  echo --enable-asm-optimizations >> args
if "%ASM%" == "disabled"                 echo --disable-asm-optimizations >> args
if "%SSE%" == "enabled"                  echo --enable-sse >> args
if "%SSE%" == "disabled"                 echo --disable-sse >> args
if not "%ARGS%" == ""                    echo %ARGS% >> args

echo --prefix=/dev/env/DJDIR >> args

set ARGS=
set CACHING=
set DEPENDENCY_TRACKING=
set LIBICONV_PREFIX=
set LIBINTL_PREFIX=
set HTML=
set SILENT=
set FLAC++=
set ASM=
set SSE=

if "%XSRC%" == "." goto InPlace

:NotInPlace
redir -e /dev/null update %XSRC%/configure.org ./configure
test -f ./configure
if errorlevel 1 update %XSRC%/configure ./configure

:InPlace
Rem Update configuration files
echo Updating configuration scripts...
test -f ./configure.org
if errorlevel 1 update configure configure.org
sed -f %XSRC%/djgpp/config.sed configure.org > filename.ext
if errorlevel 1 goto Sed1Error
sed "/symlink /s/\x60//g" ./filename.ext > filename.out
mv -f ./filename.out ./configure
dtou ./configure
touch -r configure.org ./configure
rm -f ./filename.ext

Rem Make sure they have a config.site file
set CONFIG_SITE=%XSRC%/djgpp/config.site
if not "%CONFIG_SITE%" == "%XSRC%/djgpp/config.site" goto SmallEnv

Rem Make sure crucial file names are not munged by unpacking
test -f %XSRC%/config.h.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/config.h.in %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/config.h %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/configh.in %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/config_h.in %XSRC%/config.h-in
test -f %XSRC%/po/Makefile.am.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.am.in %XSRC%/po/Makefile.am-in
test -f %XSRC%/po/Makefile.am-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.am %XSRC%/po/Makefile.am-in
test -f %XSRC%/po/Makefile.in.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.in.in %XSRC%/po/Makefile.in-in
test -f %XSRC%/po/Makefile.in-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.in %XSRC%/po/Makefile.in-in


test -d %XSRC%/include/FLAC++
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/include/FLAC++ %XSRC%/include/FLACXX
test -d %XSRC%/include/FLACXX
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/include/FLACPP %XSRC%/include/FLACXX
test -d %XSRC%/include/FLACXX
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/include/FLAC__ %XSRC%/include/FLACXX

test -d %XSRC%/src/libFLAC++
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/libFLAC++ %XSRC%/src/libFLACXX
test -d %XSRC%/src/libFLACXX
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/libFLACPP %XSRC%/src/libFLACXX
test -d %XSRC%/src/libFLACXX
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/libFLAC__ %XSRC%/src/libFLACXX

test -f %XSRC%/src/libFLACXX/flac++.pc.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/libFLACXX/flac++.pc.in %XSRC%/src/libFLACXX/flacxx.pc.in
test -f %XSRC%/src/libFLACXX/flacxx.pc.in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/libFLACXX/flacpp.pc.in %XSRC%/src/libFLACXX/flacxx.pc.in
test -f %XSRC%/src/libFLACXX/flacxx.pc.in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/libFLACXX/flac__.pc.in %XSRC%/src/libFLACXX/flacxx.pc.in

::test -f %XSRC%/src/libFLACXX/flacxx.pc.in
::if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/libFLACXX/flacxx.pc.in %XSRC%/src/libFLACXX/flacxx.pc-in
::test -f %XSRC%/src/libFLACXX/flacxx.pc-in
::if errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/libFLACXX/flacxx.pc %XSRC%/src/libFLACXX/flacxx.pc-in
::test -f %XSRC%/src/libFLACXX/flacxx.pc-in
::if errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/libFLACXX/flacxxpc.in %XSRC%/src/libFLACXX/flacxx.pc-in
::test -f %XSRC%/src/libFLACXX/flacxx.pc-in
::if errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/libFLACXX/flacxx_pc.in %XSRC%/src/libFLACXX/flacxx.pc-in

test -f %XSRC%/src/libFLACXX/libFLAC++.m4
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/libFLACXX/libFLAC++.m4 %XSRC%/src/libFLACXX/libFLACXX.m4
test -f %XSRC%/src/libFLACXX/libFLACXX.m4
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/libFLACXX/libFLACPP.m4 %XSRC%/src/libFLACXX/libFLACXX.m4
test -f %XSRC%/src/libFLACXX/libFLACXX.m4
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/libFLACXX/libFLAC__.m4 %XSRC%/src/libFLACXX/libFLACXX.m4

test -d %XSRC%/src/test_libFLAC++
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/test_libFLAC++ %XSRC%/src/test_libFLACXX
test -d %XSRC%/src/test_libFLACXX
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/test_libFLACPP %XSRC%/src/test_libFLACXX
test -d %XSRC%/src/test_libFLACXX
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/test_libFLAC__ %XSRC%/src/test_libFLACXX

test -f %XSRC%/test/test_libFLAC++.sh
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/test/test_libFLAC++.sh %XSRC%/test/test_libFLACXX.sh
test -f %XSRC%/test/test_libFLACXX.sh
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/test/test_libFLACPP.sh %XSRC%/test/test_libFLACXX.sh
test -f %XSRC%/test/test_libFLACXX.sh
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/test/test_libFLAC__.sh %XSRC%/test/test_libFLACXX.sh


:# Beginn  Zusaetzliche zu veraendernde Dateinamen.
:test -f %XSRC%/man/libflac.in
:if not errorlevel redir -e /dev/null 1 mv -f %XSRC%/man/libflac..in %XSRC%/man/libflac.-in
:test -f %XSRC%/man/libflac.-in
:if errorlevel 1 redir -e /dev/null mv -f %XSRC%/man/libflac. %XSRC%/man/libflac.-in
:# Ende  Zusaetzliche zu veraendernde Dateinamen.

Rem Update libtool files
echo Updating libtool scripts...
test -f %XSRC%/ltmain.org
if errorlevel 1 update %XSRC%/ltmain.sh %XSRC%/ltmain.org
sed -f %XSRC%/djgpp/ltmain.sed %XSRC%/ltmain.org > ltmain.tmp
if errorlevel 1 goto Sed16Error
dtou ltmain.tmp
mv -f ltmain.tmp %XSRC%/ltmain.sh

Rem This is required because DOS/Windows are case-insensitive
Rem to file names, and "make install" will do nothing if Make
Rem finds a file called `install'.
if exist INSTALL ren INSTALL INSTALL.txt

Rem Set SHELL to a sane default or some configure tests stop working
Rem if the package is configured across partitions.
if not "%SHELL%" == "" goto HomeName
set SHELL=/bin/sh
if not "%SHELL%" == "/bin/sh" goto SmallEnv
echo No SHELL found in the environment, using default value

:HomeName
Rem Set HOME to a sane default so configure stops complaining.
if not "%HOME%" == "" goto HostName
set HOME=%XSRC%/djgpp
if not "%HOME%" == "%XSRC%/djgpp" goto SmallEnv
echo No HOME found in the environment, using default value

:HostName
Rem Set HOSTNAME so it shows in config.status
if not "%HOSTNAME%" == "" goto hostdone
if "%windir%" == "" goto msdos
set OS=MS-Windows
if not "%OS%" == "MS-Windows" goto SmallEnv
goto haveos
:msdos
set OS=MS-DOS
if not "%OS%" == "MS-DOS" goto SmallEnv
:haveos
if not "%USERNAME%" == "" goto haveuname
if not "%USER%" == "" goto haveuser
echo No USERNAME and no USER found in the environment, using default values
set HOSTNAME=Unknown PC
if not "%HOSTNAME%" == "Unknown PC" goto SmallEnv
goto userdone
:haveuser
set HOSTNAME=%USER%'s PC
if not "%HOSTNAME%" == "%USER%'s PC" goto SmallEnv
goto userdone
:haveuname
set HOSTNAME=%USERNAME%'s PC
if not "%HOSTNAME%" == "%USERNAME%'s PC" goto SmallEnv
:userdone
set _HOSTNAME=%HOSTNAME%, %OS%
if not "%_HOSTNAME%" == "%HOSTNAME%, %OS%" goto SmallEnv
set HOSTNAME=%_HOSTNAME%
:hostdone
set _HOSTNAME=
set OS=

Rem install-sh is required by the configure script but clashes with the
Rem various Makefile install-foo targets, so we MUST have it before the
Rem script runs and rename it afterwards
test -f %XSRC%/install-sh
if not errorlevel 1 goto NoRen0
test -f %XSRC%/install-sh.sh
if not errorlevel 1 mv -f %XSRC%/install-sh.sh %XSRC%/install-sh
:NoRen0

if "%NLS%" == "disabled" goto WithoutNLS

:WithNLS
test -d %XSRC%/po
if errorlevel 1 goto WithoutNLS

Rem Check for the needed libraries and binaries.
test -x /dev/env/DJDIR/bin/msgfmt.exe
if errorlevel 1 goto MissingNLSTools
test -x /dev/env/DJDIR/bin/xgettext.exe
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libcharset.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libcharset.a
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/iconv.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libiconv.a
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libintl.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libintl.a
if errorlevel 1 goto MissingNLSTools

Rem Recreate the files in the %XSRC%/po subdir with our ported tools.
redir -e /dev/null rm %XSRC%/po/*.gmo
redir -e /dev/null rm %XSRC%/po/libflac.pot
redir -e /dev/null rm %XSRC%/po/cat-id-tbl.c
redir -e /dev/null rm %XSRC%/po/stamp-cat-id

Rem Update the arguments file for the configure script.
Rem We prefer without-included-gettext because libintl.a from gettext package
Rem is the only one that is garanteed to have been ported to DJGPP.
echo --enable-nls --without-included-gettext >> args
goto ConfigurePackage

:MissingNLSTools
echo Needed DJGPP ports of the required libs/tools for NLS support not found.
echo Configuring without NLS.
:WithoutNLS
Rem Update the arguments file for the configure script.
echo --disable-nls >> args

:ConfigurePackage
echo Running the ./configure script...
sh ./configure @args
if errorlevel 1 goto RunConfigStatus
rm args
echo Done.
goto EditFiles
:RunConfigStatus
test -f ./config.status
if errorlevel 1 goto CfgError
echo Running the ./config.status script (manually)...
redir -e /dev/null sh ./config.status
if errorlevel 1 goto CfgError
rm args
echo Done.

:EditFiles
echo Editing config.h...
test -f ./config.h
if errorlevel 1 goto InLibDir
:test -f ./config_h.org
:if errorlevel 1 update ./config.h ./config_h.org
update ./config.h ./config_h.org
sed -f %XSRC%/djgpp/config_h.sed ./config_h.org > config.h
if errorlevel 1 goto Sed2Error
echo Done.
goto NextEdit
:InLibDir
:test -f ./lib/config_h.org
:if errorlevel 1 update ./lib/config.h ./lib/config_h.org
update ./lib/config.h ./lib/config_h.org
sed -f %XSRC%/djgpp/config_h.sed ./lib/config_h.org > config.h
if errorlevel 1 goto Sed2Error
mv config.h ./lib/config.h
echo Done.

:NextEdit
echo Editing test/common.sh...
:test -f ./test/common.sh.org
:if errorlevel 1 update ./test/common.sh ./test/common.sh.org
update ./test/common.sh ./test/common.sh.org
sed -f %XSRC%/djgpp/fix_test.sed ./test/common.sh.org > common.tst
if errorlevel 1 goto Sed3Error
mv common.tst ./test/common.sh
echo Done.

echo Editing test/test_libFLAC.sh...
test -f %XSRC%/test/test_libFLAC.sh.org
if errorlevel 1 update %XSRC%/test/test_libFLAC.sh %XSRC%/test/test_libFLAC.sh.org
:update %XSRC%/test/test_libFLAC.sh %XSRC%/test/test_libFLAC.sh.org
sed -f %XSRC%/djgpp/fix_test.sed %XSRC%/test/test_libFLAC.sh.org > test_libFLAC.tst
if errorlevel 1 goto Sed4Error
mv test_libFLAC.tst %XSRC%/test/test_libFLAC.sh
echo Done.

echo Editing test/test_libFLACXX.sh...
test -f %XSRC%/test/test_libFLACXX.sh.org
if errorlevel 1 update %XSRC%/test/test_libFLACXX.sh %XSRC%/test/test_libFLACXX.sh.org
:update %XSRC%/test/test_libFLACXX.sh %XSRC%/test/test_libFLACXX.sh.org
sed -f %XSRC%/djgpp/fix_test.sed %XSRC%/test/test_libFLACXX.sh.org > test_libFLACXX.tst
if errorlevel 1 goto Sed5Error
mv test_libFLACXX.tst %XSRC%/test/test_libFLACXX.sh
echo Done.

echo Editing test/test_grabbag.sh...
test -f %XSRC%/test/test_grabbag.sh.org
if errorlevel 1 update %XSRC%/test/test_grabbag.sh %XSRC%/test/test_grabbag.sh.org
:update %XSRC%/test/test_grabbag.sh %XSRC%/test/test_grabbag.sh.org
sed -f %XSRC%/djgpp/fix_test.sed %XSRC%/test/test_grabbag.sh.org > test_grabbag.tst
if errorlevel 1 goto Sed6Error
mv test_grabbag.tst %XSRC%/test/test_grabbag.sh
echo Done.

echo Editing test/test_flac.sh...
test -f %XSRC%/test/test_flac.sh.org
if errorlevel 1 update %XSRC%/test/test_flac.sh %XSRC%/test/test_flac.sh.org
:update %XSRC%/test/test_flac.sh %XSRC%/test/test_flac.sh.org
sed -f %XSRC%/djgpp/fix_test.sed %XSRC%/test/test_flac.sh.org > test_flac.tst
if errorlevel 1 goto Sed7Error
mv test_flac.tst %XSRC%/test/test_flac.sh
echo Done.

echo Editing test/test_metaflac.sh...
test -f %XSRC%/test/test_metaflac.sh.org
if errorlevel 1 update %XSRC%/test/test_metaflac.sh %XSRC%/test/test_metaflac.sh.org
:update %XSRC%/test/test_metaflac.sh %XSRC%/test/test_metaflac.sh.org
sed -f %XSRC%/djgpp/fix_test.sed %XSRC%/test/test_metaflac.sh.org > test_metaflac.tst
if errorlevel 1 goto Sed8Error
mv test_metaflac.tst %XSRC%/test/test_metaflac.sh
echo Done.

echo Editing test/test_replaygain.sh...
test -f %XSRC%/test/test_replaygain.sh.org
if errorlevel 1 update %XSRC%/test/test_replaygain.sh %XSRC%/test/test_replaygain.sh.org
:update %XSRC%/test/test_replaygain.sh %XSRC%/test/test_replaygain.sh.org
sed -f %XSRC%/djgpp/fix_test.sed %XSRC%/test/test_replaygain.sh.org > test_replaygain.tst
if errorlevel 1 goto Sed9Error
mv test_replaygain.tst %XSRC%/test/test_replaygain.sh
echo Done.

echo Editing test/test_seeking.sh...
test -f %XSRC%/test/test_seeking.sh.org
if errorlevel 1 update %XSRC%/test/test_seeking.sh %XSRC%/test/test_seeking.sh.org
:update %XSRC%/test/test_seeking.sh %XSRC%/test/test_seeking.sh.org
sed -f %XSRC%/djgpp/fix_test.sed %XSRC%/test/test_seeking.sh.org > test_seeking.tst
if errorlevel 1 goto Sed10Error
mv test_seeking.tst %XSRC%/test/test_seeking.sh
echo Done.

echo Editing test/test_streams.sh...
test -f %XSRC%/test/test_streams.sh.org
if errorlevel 1 update %XSRC%/test/test_streams.sh %XSRC%/test/test_streams.sh.org
:update %XSRC%/test/test_streams.sh %XSRC%/test/test_streams.sh.org
sed -f %XSRC%/djgpp/fix_test.sed %XSRC%/test/test_streams.sh.org > test_streams.tst
if errorlevel 1 goto Sed11Error
mv test_streams.tst %XSRC%/test/test_streams.sh
echo Done.

echo Editing test/test_compression.sh...
test -f %XSRC%/test/test_compression.sh.org
if errorlevel 1 update %XSRC%/test/test_compression.sh %XSRC%/test/test_compression.sh.org
:update %XSRC%/test/test_compression.sh %XSRC%/test/test_compression.sh.org
sed -f %XSRC%/djgpp/fix_test.sed %XSRC%/test/test_compression.sh.org > test_compression.tst
if errorlevel 1 goto Sed12Error
mv test_compression.tst %XSRC%/test/test_compression.sh
echo Done.


Rem Create po/LINGUAS file or the build fails.
update %XSRC%/po/LINGUAS ./po/LINGUAS
goto End

:Sed1Error
echo ./configure script editing failed!
goto End

:Sed2Error
echo config.h fixing failed!
goto End

:Sed3Error
echo test/common.sh fixing failed!
goto End

:Sed4Error
echo test/test_libFLAC.sh fixing failed!
goto End

:Sed5Error
echo test/test_libFLACXX.sh fixing failed!
goto End

:Sed6Error
echo test/test_grabbag.sh fixing failed!
goto End

:Sed7Error
echo test/test_flac.sh fixing failed!
goto End

:Sed8Error
echo test/test_metaflac.sh fixing failed!
goto End

:Sed9Error
echo test/test_replaygain.sh fixing failed!
goto End

:Sed10Error
echo test/test_seeking.sh fixing failed!
goto End

:Sed11Error
echo test/test_streams.sh fixing failed!
goto End

:Sed12Error
echo test/test_compression.sh fixing failed!
goto End

:CfgError
echo ./configure script exited abnormally!
goto End

:SmallEnv
echo Your environment size is too small.  Enlarge it and run me again.
echo Configuration NOT done!

:End
test -f %XSRC%/install-sh.sh
if not errorlevel 1 goto NoRen1
test -f %XSRC%/install-sh
if not errorlevel 1 mv -f %XSRC%/install-sh %XSRC%/install-sh.sh
:NoRen1
if "%SHELL%" == "/bin/sh" set SHELL=
if "%HOME%" == "%XSRC%/djgpp" set HOME=
set ARGS=
set CONFIG_SITE=
set HOSTNAME=
set NLS=
set CACHING=
set DEPENDENCY_TRACKING=
set SILENT=
set FLAC++=
set ASM=
set SSE=
set XSRC=
