/****************************************************************************/
/* TGROUP                                                                   */
/*--------------------------------------------------------------------------*/
/* Objet TGroup (Type gnrique d'objet comprenant d'autres objets dont un  */
/*               seul  la fois a le focus)                                 */
/****************************************************************************/

#ifndef _TGROUP_H_
#define _TGROUP_H_

#include "Types.h"

#include "Keyboard.h"

#include "TObject.h"


class TGroup:public TObject
{
  /*-------------*/
  /* Objets amis */
  /*-------------*/

  friend class TObject;	// Pour que les objets puissent se
		  				// rajouter au groupe...

  /*-----------------*/
  /* Champs protgs */
  /*-----------------*/

  protected:

    // Objet du groupe qui a le focus

    PObjectNode f_focused_element;

    // Indique si le groupe peut n'avoir aucun lment
    // avec le focus quand lui l'a

    bool f_need_focused_element;

  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

		    TGroup(PObject parent,
			   int type,
			   int rel_x,int rel_y,
			   int width,int height,
			   unsigned background,
			   const char *caption,
			   bool enabled,
			   bool focus_depending_aspect,
                           bool can_be_enabled,
			   bool need_focused_element);
    virtual         ~TGroup();

    // Mthodes d'accs

    virtual PObject m_get_focused_element();

    // Donne le focus au groupe (au 1er/dernier de ses objets qui le veut)

    virtual bool m_can_lose_focus();
    virtual bool m_set_focus();
    virtual bool m_set_focus_to_last_element();

    // Donne le focus (si possible)  celui qui prcde ou suit celui
    // qui a le focus

    virtual bool m_set_focus_to_previous_element();
    virtual bool m_set_focus_to_next_element();


    // Retourne l'objet du groupe qui a le focus

    virtual PObject m_get_focused_object();


  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:

    virtual void    m_del_element(int object_number);

    // Attribution du focus  un objet du groupe

    virtual bool m_set_focus_to_element(int object_number);

    // Prise/Perte du focus

    virtual void    m_lose_focus();

    virtual void    m_take_focus();

    // Evnements

    virtual bool m_left_button_pressed_event(int x,int y);
    virtual bool m_left_button_double_click_event(int x,int y);
    virtual bool m_key_pressed_event(TKey key);

  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

    // Evnements

    virtual bool m_tab_pressed_event();
    virtual bool m_shift_tab_pressed_event();

    // L'objet peut obtenir le focus lors d'un dplacement
    // avec les touches flches

    virtual bool m_focus_can_be_set_by_arrow_key() { return false; };
};

#endif
