
all: jptui.inf

clean:
	-del jptui.txi
	-del jptuisrc.all

test: all
	info -d . -f jptui.inf

install: all
	cp jptui.i* $(DJDIR)/info
	$(DJDIR)/bin/install- jptui.inf $(DJDIR)/info/dir
#	instinfo jptui.inf $(DJDIR)/info/dir

dist: all
	mkdir -p src2info
	cp -pu inclsrc.awk makefile src2info.bat src2info.mak src2texi.awk src2info
	zip -u src2info src2info


jptui.src:
	@echo Please copy all the .src files into the current directory.

jptuisrc.all: jptui.src *.src inclsrc.awk
	@echo    Merging all the include files, starting from jptui.src.
	gawk -f inclsrc.awk jptui.src >$@

jptui.txi: jptuisrc.all src2texi.awk
	@echo    Translating the merged src files to Texinfo file $@.
	gawk -f src2texi.awk jptuisrc.all >$@

jptui.inf: jptui.txi
	@echo    Making the Info files (jptui.inf, jptui.i1...).
	@echo set LFN=n >_src2inf.bat
	@echo makeinfo --fill-column 77 --verbose $^ >>_src2inf.bat
	_src2inf.bat
	-del _src2inf.bat
