/****************************************************************************/
/* JPDEBUG                                                                  */
/*--------------------------------------------------------------------------*/
/* JPTUI Debugging macros                                                   */
/****************************************************************************/

#ifndef _JPDEBUG_H
#define _JPDEBUG_H

#include "Debug.h"
#include "Settings.h"

/*ͻ*/
/*                                  MACROS                                */
/*ͼ*/

 #ifdef NDEBUG

 #  define JPDEBUG_STOP(cause)
 #  define JPDEBUG_TEST(cause,condition)

 #else

 #  define JPDEBUG_STOP(cause)            ProgrammingError(cause, __FILE__, __LINE__)
 #  define JPDEBUG_TEST(cause,condition)  ((condition) ? (void)0 : JPDEBUG_STOP(cause))

 // Error codes

 enum
   {
     DEBUG_ERROR_1=1,
     DEBUG_ERROR_2,
     DEBUG_ERROR_3,
     DEBUG_ERROR_4,
     DEBUG_ERROR_5,
     DEBUG_ERROR_6,
     DEBUG_ERROR_7,
     DEBUG_ERROR_8,
     DEBUG_ERROR_9,
     DEBUG_ERROR_10,
     DEBUG_ERROR_11,
     DEBUG_ERROR_12,
     DEBUG_ERROR_13,
     DEBUG_ERROR_14,
     DEBUG_ERROR_15,
     DEBUG_ERROR_16,
     DEBUG_ERROR_17,
     DEBUG_ERROR_18,
     DEBUG_ERROR_19,
     DEBUG_ERROR_20,
     DEBUG_ERROR_21,
     DEBUG_ERROR_22,
     DEBUG_ERROR_23,
     DEBUG_ERROR_24,
     DEBUG_ERROR_25,
     DEBUG_ERROR_26,
     DEBUG_ERROR_27,
     DEBUG_ERROR_28,
     DEBUG_ERROR_29,
     DEBUG_ERROR_30,
     DEBUG_ERROR_31,
     DEBUG_ERROR_32,
   };


 #endif

#endif
