/*****************************************************************************/
/* CONST                                                                     */
/*---------------------------------------------------------------------------*/
/* JPTUI Constants                                                           */
/*---------------------------------------------------------------------------*/
/* Author      : DELPRAT Jean-Pierre                                         */
/* Created on  : 12/06/94                                                    */
/*****************************************************************************/

#ifndef _CONST_H_
#define _CONST_H_

#include "Keyboard.h"
#include "Settings.h"
#include "ShortCut.h"

/*ͻ*/
/*                                 MACROS                                 */
/*ͼ*/

  #ifndef MIN
  #define MIN(a,b)    (((a) <= (b)) ? (a) : (b))
  #endif

  #ifndef MAX
  #define MAX(a,b)    (((a) >= (b)) ? (a) : (b))
  #endif

/*ͻ*/
/*                                CONSTANTS                               */
/*ͼ*/

// Attributes of the different objects of the user interface

#define DISABLED                     false
#define ENABLED      		     true

#define NOT_CHECKED 		     false
#define CHECKED     		     true

#define NOT_SORTED                   false
#define SORTED                       true

#define NOT_MODAL                    false
#define MODAL                        true

#define NO_INFO_BAR		     false
#define INFO_BAR                     true

#define NOT_MOVABLE                  false
#define MOVABLE                      true

#define STRING_NEEDNT_TO_BE_IN_LIST  false
#define STRING_MUST_BE_IN_LIST       true

// List items attributes
// (you can define several attributes at the same time
//  -> LI_DISABLED|LI_CHECKED...)

#define LI_NOATTR                    (0x0000)
#define LI_DISABLED                  (0x0001)
#define LI_CHECKED                   (0x0002)
#define LI_TOGGLE                    (0x0004)

// Object Type Definitions

#define OBJ_NONE           -1

#define OBJ_CHECK_BOX       0
#define OBJ_COMBO_LIST      1
#define OBJ_EDIT_ZONE       2
#define OBJ_FRAME_GROUP     3
#define OBJ_GAUGE           4
#define OBJ_LABEL           5
#define OBJ_LIST_BOX        6
#define OBJ_MENU            7
#define OBJ_MENU_BAR        8
#define OBJ_PUSH_BUTTON     9
#define OBJ_SCROLL_BAR     10
#define OBJ_TAB            11
#define OBJ_TAB_GROUP      12
#define OBJ_TEXT_ZONE      13
#define OBJ_WINDOW         14

#endif
