/* Based on coff.h */
/* coff.h is Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
/* dlm.h  is Copyright (C) 1996 Ilya P. Ryzhenkov, see COPYDLM.TXT for details */

#ifndef __include_dlm_h_
#define __include_dlm_h_

/* workaround of C++ bug */
#pragma pack(1)

#ifdef __cplusplus
extern "C" {
#endif

/*** DLM information for Intel 386/486.  */
/*
 Overall DLM file structure :
  1. File Header (_dlm_filehdr structure)
  2. Section Headers (_dlm_scnhdr structures of f_nscns number)
  3. Symbol Table (_dlm_syment structure of f_nsyms number)
  4. Relocation Table (_dlm_reloc structures of f_nreloc number)
  5. String Table (null terminated of f_strsz byte size)
  6. Section Data
*/

/********************** FILE HEADER **********************/
struct _dlm_filehdr {
        unsigned long  f_magic;         /* magic number (for DLM is 0x464d4c44 )*/
        unsigned long  f_timdat;   /* time & date stamp */
        unsigned short f_nscns;         /* number of sections */
        unsigned long  f_vsize;         /* virtual total size of section's data */
        unsigned long  f_nreloc;        /* number of relocations */
        unsigned long  f_nsyms;         /* number of symtab entries */
        unsigned long  f_strsz;    /* size of string table */
        unsigned short f_flags;         /* flags        */
};

typedef struct _dlm_filehdr DLMHDR;
#define DLMHDRSZ  sizeof(DLMHDR)
#define  DLM_MAGIC 0x464d4c44

/********************** SECTION HEADER **********************/

struct _dlm_scnhdr {
        char                    s_name[8];     /* section name                 */
        unsigned long           s_vaddr;           /* virtual address           */
        unsigned long           s_size;         /* section size                 */
        unsigned long           s_scnptr;       /* file ptr to raw data for section */
        unsigned long           s_flags;           /* flags                     */
};

typedef struct _dlm_scnhdr DLMSCN;
#define DLMSCNSZ  sizeof(DLMSCN)

/*
 * names of "special" sections
 */
#define _DLMTEXT        ".text"
#define _DLMDATA        ".data"
#define _DLMBSS ".bss"
#define _DLMCOMMENT ".comment"
#define _DLMLIB ".lib"

/*
 * s_flags "type"
 */
#define STYP_TEXT        (0x0020)       /* section contains text only */
#define STYP_DATA        (0x0040)       /* section contains data only */
#define STYP_BSS         (0x0080)       /* section contains bss only */

/********************** SYMBOLS **********************/

struct _dlm_syment
{
  unsigned long  e_name;  /* offset in string table (absent if -1) */
  unsigned long  e_value; /* value of symbol */
  unsigned short e_flags; /* flags for symbol (includes type and other) */
};
/*  short e_scnum;  doesn't matter now in which section symbol is located */

#define DLMSYM_IMPORT 1
#define DLMSYM_EXPORT 2
#define DLMSYM_SECTION 4
#define DLMSYM_COMMON 8

#define DLMSYM_NONAME ((unsigned long)-1)

typedef struct _dlm_syment DLMSYM;
#define DLMSYMSZ sizeof(DLMSYM)

/********************** RELOCATION DIRECTIVES **********************/

struct _dlm_reloc {
  unsigned long  r_vaddr; /* offset in sections image */
  unsigned long  r_symndx; /* index of symbol for relocation*/
  unsigned short r_flags; /* flags and relocation type */
};


typedef struct _dlm_reloc DLMREL;
#define DLMRELSZ sizeof(DLMREL)

#define DLMREL_TYPE     1  /* & with r_flags */
#define DLMREL_REL32       0    /* 32-bit PC-relative address */
#define DLMREL_ABS32    1       /* 32-bit absolute address */

#ifdef __cplusplus
}
#endif

/* workaround of C++ bug */
#pragma pack()

#endif /* !__include_dlm_h_ */
