#include <stdio.h>

#include "colour.h"
#include "desktop.h"
#include "error.h"
#include "event.h"
#include "group.h"
#include "misc.h"
#include "refresh.h"
#include "statbar.h"

/*

	statbar.c

		Handles the status bar.

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	FUNCTION	PROTOTYPES
*/

static	bool	StatusBar_EventHandler(	void *aStatusBar, T_EventRec *aEvent );
static	void	StatusBar_Draw( T_StatusBar *aStatusBar, T_EventDrawParameters *aParams );
static	void	StatusBar_Kill( T_StatusBar *aStatusBar );

/*
	FUNCTION	DEFINITIONS
*/

void	StatusBar_Draw( T_StatusBar *aStatusBar, T_EventDrawParameters *aParams )
{
	char	lStr[81], lStr2[81];

	int	lX1 = aParams->fX, lX2 = lX1+aStatusBar->fWidth-1, lY = aParams->fY;

	T_Buffer	*lBuffer = aParams->fBuffer;

	if ( aStatusBar->fStatusString != NULL )
	{
		strncpy( lStr2, aStatusBar->fStatusString, aStatusBar->fWidth-12 );
		lStr2[aStatusBar->fWidth-12] = EOS;
	}
	else
	{
		lStr2[0] = EOS;
	}

	sprintf(	lStr, "    Help  %-*s ", aStatusBar->fWidth-12, lStr2 );

	lX2 = MIN( lBuffer->fWidth-1, lX1+aStatusBar->fWidth-1 );

	Buffer_Print( lBuffer, lX1, lY, lX2, lY, lStr, COLOUR_MENU_TEXT );
	Buffer_Print( lBuffer, lX1+1, lY, lX2, lY, "F1", COLOUR_MENU_HILITE );
}

void	StatusBar_SetStatusString( T_StatusBar *aStatusBar, const char *aString )
{
	if ( aStatusBar->fStatusString != NULL )
	{
		free(	aStatusBar->fStatusString );
	}
	P_CreateStr( aStatusBar->fStatusString, aString );
	Refresh_AddDirtyRectangle( aStatusBar->fOwner );
}

T_StatusBar *StatusBar_Initialise( void )
{
	T_StatusBar *lStatusBar;

	P_InitVar( lStatusBar, T_StatusBar );

	DesktopObj_Initialise( lStatusBar, StatusBar_EventHandler, false );

	lStatusBar->fStatusString = NULL;

	return lStatusBar;
}

void	StatusBar_Kill( T_StatusBar *aStatusBar )
{
	if ( aStatusBar->fStatusString != NULL )
	{
		free( aStatusBar->fStatusString );
	}
	free( aStatusBar );
}

bool	StatusBar_EventHandler(	void *aStatusBar, T_EventRec *aEvent )
{
	bool	lRetVal = false;

	switch ( aEvent->fMessage )
	{
		case	EVENT_KILL:
			StatusBar_Kill( aStatusBar );
			lRetVal = true;
			break;
		case	EVENT_DRAW:
			StatusBar_Draw( aStatusBar, &aEvent->fParameters.fDrawParams );
			lRetVal = true;
			break;
		case	EVENT_KEYPRESS:
			/// implications for buttons on it?
			break;
		case	EVENT_COMMANDENABLED:
			/// implications for buttons on it?
			break;
		case	EVENT_LEFTMOUSECLICK:
			/// implications for buttons on it?
			break;
		case	EVENT_RIGHTMOUSECLICK:
			break;
		case	EVENT_CANFOCUS:
			lRetVal = false;
			break;
		case	EVENT_SHOW:
		case	EVENT_HIDE:
			break;
		default:
			FatalError( "Unhandled message" );
			break;
	}
	return lRetVal;
}



