/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** CB.CC: This file is part of the BETATRON library and can be used
 **        and/or distributed only under the terms of the GNU Library
 **        General Public License. See doc/readme.1st for details.
 */



#include "plvga.h"

// a really strange thing happened
// jcxz command jumped to a random position
// and crashed the program; when i changed it to jecxz
// it seemed to work but you never know

// fainetai oti o as paragei ena prefix 66h gia tin
// entoli jcxz eno to sosto einai na paragei prefix 67h
// fainetai oti paragei to sosto opcode gia tin entoli
// jecxz

// mikos tou "from" kai "to" buffer antistoixa (short)
long pl_screenbufsize;
char *pl_screenbuf;
long pl_screenbuflen;

long pl_videosize;
short pl_videoselector;
long  pl_videolen;


// xrisimopoio katholikes metavlites giati den mporo na peraso pano apo
// 10 parametrous se ena asm template
static long start1,start2;
static long step1,step2;
static short l,h;
static long h1,l1,h2,l2a,l2b;
static char *source;
static char fromfirst;	 // teleionei to from proto boolean
			 // gia tin periptosi pou exoume diplo circle
			 // gia tin periptosi tou aplou circle
			 // dilonei pio apo ta dio ("from" i "to" )
			 // kanei kiklo



//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------


void M2Vplanarsolid4(char *from,
		   long toofs, unsigned short tox,unsigned short toy,
		   unsigned short len,unsigned short hei,
		   unsigned short fromx,unsigned short fromy,
		   unsigned short fromlen)
{

// i metavliti notusedfromhei den xrisimopoieitai einai aplos
// gia simbatotita me ti dilosi tis M2Vsolidclipspr

 toofs<<=2;  // gia simvatotita me to modex einai /4
 l=len;
 h=hei;
 step1=fromlen-l;
 step2=pl_videolen-l;
 source=from;
 start1=fromy*fromlen+fromx;
 start2=toofs+toy*pl_videolen+tox;


asm("   pusha
   pushw  %fs
	xorl   %ecx,%ecx

	movl  _start1, %edi
   addl  _source, %edi

   movw  _pl_videoselector, %ax
   movw   %ax, %fs
	movl  _start2, %esi

#----------------------------------------------------------------------------
# antegrapse h grammes
#----------------------------------------------------------------------------

	movw  _h, %dx

	testw  %dx, %dx
	jz mvnc4_vl1e
mvnc4_vl1:
	movw   _l, %cx
	shrw   $2, %cx
	jecxz	  mvnc4_skip3
mvnc4_hl1:
	movl   (%edi), %eax
	movl   %eax, %fs:(%esi)
	addl   $4, %edi
	addl   $4, %esi
	decw   %cx
	testw  %cx,%cx
	jnz    mvnc4_hl1
mvnc4_skip3:
	 addl  _step1, %edi
	 addl  _step2, %esi
	 decw  %dx
	 testw %dx, %dx
	 jne   mvnc4_vl1
mvnc4_vl1e:

    popw %fs
    popa");
}












void M2Vplanarthru(char *from,
		   long toofs, unsigned short tox,unsigned short toy,
		   unsigned short len,unsigned short hei,
		   unsigned short fromx,unsigned short fromy,
		   unsigned short fromlen)
{
 toofs<<=2;  // gia simvatotita me to modex einai /4

 l=len;
 h=hei;
 step1=fromlen-l;
 step2=pl_videolen-l;
 source=from;
 start1=fromy*fromlen+fromx;
 start2=toofs+toy*pl_videolen+tox;

asm("   pusha
   pushw %fs
	xorl   %ecx,%ecx
	movl  _start1, %edi
   addl  _source, %edi

	movl  _start2, %esi
   movw  _pl_videoselector, %ax
   movw  %ax, %fs

	movw  _h, %dx

	testw  %dx, %dx
	jz mvncthru_vl1e
mvncthru_vl1:
	movw   _l, %cx
mvncthru_hl1:
	movb   (%edi), %al
   testb  %al,%al
   jz	  mvncthru_skipbyte
	movb   %al,%fs:(%esi)
mvncthru_skipbyte:
   incl   %edi
   incl   %esi
	decw   %cx
	testw  %cx,%cx
	jnz    mvncthru_hl1

	addl  _step1, %edi
	addl  _step2, %esi
	decw  %dx
   testw %dx, %dx
	jnz   mvncthru_vl1
mvncthru_vl1e:

    popw %fs
    popa");

}
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------

void M2Vplanarsolid(char *from,
		   long toofs, unsigned short tox,unsigned short toy,
		   unsigned short len,unsigned short hei,
		   unsigned short fromx,unsigned short fromy,
		   unsigned short fromlen, unsigned short notusedfromhei)
{

// i metavliti notusedfromhei den xrisimopoieitai einai aplos
// gia simbatotita me ti dilosi tis M2Vsolidclipspr

 toofs<<=2;  // gia simvatotita me to modex einai /4
 l=len;
 h=hei;
 step1=fromlen-l;
 step2=pl_videolen-l;
 source=from;
 start1=fromy*fromlen+fromx;
 start2=toofs+toy*pl_videolen+tox;

asm("   pusha
   pushw  %fs
	xorl   %ecx,%ecx

	movl  _start1, %edi
   addl  _source, %edi

   movw  _pl_videoselector, %ax
   movw   %ax, %fs
	movl  _start2, %esi

#----------------------------------------------------------------------------
# antegrapse h grammes
#----------------------------------------------------------------------------

	movw  _h, %dx

	testw  %dx, %dx
	jz mvnc_vl1e
mvnc_vl1:
	movw   _l, %cx

	shrw   $1, %cx
	jnc    mvnc_skip1
	movb   (%edi), %al
	movb   %al, %fs:(%esi)
	incl   %edi
	incl   %esi
mvnc_skip1:
	shrw   $1, %cx
	jnc    mvnc_skip2
	movw   (%edi), %ax
	movw   %ax, %fs:(%esi)
	addl   $2, %edi
	addl   $2, %esi
mvnc_skip2:
	jecxz mvnc_skip3
mvnc_hl1:
	movl   (%edi), %eax
	movl   %eax, %fs:(%esi)
	addl   $4, %edi
	addl   $4, %esi
	decw   %cx
	testw  %cx,%cx
	jnz    mvnc_hl1
mvnc_skip3:
	 addl  _step1, %edi
	 addl  _step2, %esi
	 decw  %dx
    testw %dx, %dx
	 jne   mvnc_vl1
mvnc_vl1e:

    popw %fs
    popa");



}



//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------

void M2Mcbthru(char *from,unsigned short fromx,unsigned short fromy,
		unsigned short fromlen,
			       long toofs, unsigned short tox,unsigned short toy,
			       unsigned short len,unsigned short hei)
{
   long end2;
   long clipsize2;



 toofs<<=2;  // gia simvatotita me to modex einai /4
   source=from;
   l=len;
   h=hei;
   step1=fromlen-l;
   step2=pl_screenbuflen-l;
   start1= fromy*fromlen + fromx;
   start2=toofs + toy*pl_screenbuflen + tox;
   if (start2>=pl_screenbufsize) start2-=pl_screenbufsize;
   /////////

   end2=start2 + (hei-1)*pl_screenbuflen + (len-1);


   if (end2 > pl_screenbufsize)
   {
      clipsize2=pl_screenbufsize - start2;
      h2= clipsize2 / pl_screenbuflen;
      l2a= clipsize2 % pl_screenbuflen;
      if (l2a>len) l2a=len;
      goto circle;
   }


nocircle:
asm("   pusha
	xorl   %ecx,%ecx
	movl  _start1, %edi
   addl  _source, %edi
	movl  _start2, %esi
   addl  _pl_screenbuf, %esi

	movw  _h, %dx

	testw  %dx, %dx
	jz mcbncthru_vl1e
mcbncthru_vl1:
	movw   _l, %cx
mcbncthru_hl1:
	movb   (%edi), %al
   testb  %al,%al
   jz	  mcbncthru_skipbyte
	movb   %al,(%esi)
mcbncthru_skipbyte:
   incl   %edi
   incl   %esi
	decw   %cx
	testw  %cx,%cx
	jnz    mcbncthru_hl1

	addl  _step1, %edi
	addl  _step2, %esi
	decw  %dx
   testw %dx, %dx
	jnz   mcbncthru_vl1
mcbncthru_vl1e:

    popa");
goto fin;





circle:
asm("
   pusha
	xorl   %ecx,%ecx

	movl  _start1, %edi
   addl  _source, %edi
	movl  _start2, %esi
   addl  _pl_screenbuf, %esi
#----------------------------------------------------------------------------
# antegrapse h2 grammes
#----------------------------------------------------------------------------
   movw  _h2, %dx
	testw  %dx, %dx
	jz mcbcthru_vl1e
mcbcthru_vl1:
	movw   _l, %cx

mcbcthru_hl1:
	movb   (%edi), %al
   testb  %al,%al
   jz	  mcbncthru_skipbyte1
	movb   %al,(%esi)
mcbncthru_skipbyte1:
	incl   %edi
	incl   %esi
	decw   %cx
	testw  %cx,%cx
	jnz    mcbcthru_hl1

   addl  _step1, %edi
   addl  _step2, %esi
   decw  %dx
   testw %dx, %dx
   jnz	 mcbcthru_vl1
mcbcthru_vl1e:

#----------------------------------------------------------------------------
#   antigrapse l2a pixels
#----------------------------------------------------------------------------
	movw   _l2a, %cx
	jecxz  mcbcthru_hl2e
mcbcthru_hl2:
	movb   (%edi), %al
   testb  %al,%al
   jz	  mcbncthru_skipbyte2
	movb   %al,(%esi)
mcbncthru_skipbyte2:
	incl   %edi
	incl   %esi
	decw   %cx
	testw  %cx,%cx
	jnz    mcbcthru_hl2
mcbcthru_hl2e:

#----------------------------------------------------------------------------
#  esi-=pl_screenbufsize
#----------------------------------------------------------------------------
	subl   _pl_screenbufsize, %esi

#----------------------------------------------------------------------------
#  antigrafi ipoloipon l-l2a
#----------------------------------------------------------------------------
	movw   _l,  %cx
	subw   _l2a,%cx

	jecxz  mcbcthru_hl3e
mcbcthru_hl3:
	movb   (%edi), %al
   testb  %al,%al
   jz	  mcbncthru_skipbyte3
	movb   %al,(%esi)
mcbncthru_skipbyte3:
	incl   %edi
	incl   %esi
	decw   %cx
	testw  %cx,%cx
	jnz    mcbcthru_hl3
mcbcthru_hl3e:

	addl  _step1,%edi
	addl  _step2,%esi	  # epomeni grammi


#----------------------------------------------------------------------------
#  antegrafi ipoloipon h-h2-1 grammon
#----------------------------------------------------------------------------
    movw   _h,	%dx
    subw   _h2, %dx
    decw   %dx

    testw %dx, %dx
	 jz    mcbcthru_vl2e

mcbcthru_vl2:
	movw   _l, %cx

mcbcthru_hl21:
	movb   (%edi), %al
   testb  %al,%al
   jz	  mcbncthru_skipbyte4
	movb   %al,(%esi)
mcbncthru_skipbyte4:
	incl   %edi
	incl   %esi
	decw   %cx
	testw  %cx,%cx
	jnz    mcbcthru_hl21

	addl  _step1, %edi
	addl  _step2, %esi
	decw  %dx
	testw %dx, %dx
	jnz   mcbcthru_vl2
mcbcthru_vl2e:
    popa");


fin:
return;
}



//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------

//// Copies data from a regular buffer to a circular buffer
//// Assumes tha len % 4 = 0 for optimization reasons

void M2Mcbsolid(char *from,unsigned short fromx,unsigned short fromy,
		unsigned short fromlen,
			       long toofs, unsigned short tox,unsigned short toy,
			       unsigned short len,unsigned short hei)
{

   long end2;
   long clipsize2;


// ipotheto gia logous beltistopioiisis oti to mikos einai
// akeraio pollaplasio tou 4

   toofs<<=2;  // gia simvatotita me to modex einai /4
   source=from;
   l=len;
   h=hei;
   step1=fromlen-l;
   step2=pl_screenbuflen-l;
   start1= fromy*fromlen + fromx;
   start2=toofs + toy*pl_screenbuflen + tox;
   if (start2>=pl_screenbufsize) start2-=pl_screenbufsize;
   /////////

   end2=start2 + (hei-1)*pl_screenbuflen + (len-1);


   if (end2 > pl_screenbufsize)
   {
      clipsize2=pl_screenbufsize - start2;
      h2= clipsize2 / pl_screenbuflen;
      l2a= clipsize2 % pl_screenbuflen;
      if (l2a>len) l2a=len;
      goto circle;

   }

nocircle:
asm("   pusha
	xorl   %ecx,%ecx

	movl  _start1, %edi
   addl  _source, %edi

	movl  _start2, %esi
   addl  _pl_screenbuf, %esi

#----------------------------------------------------------------------------
# antegrapse h grammes
#----------------------------------------------------------------------------

	movw  _h, %dx

	testw  %dx, %dx
	jz mcbnc_vl1e
mcbnc_vl1:
	movw   _l, %cx
	shrw   $2, %cx	   # to mikos einai akeraio pollaplasio tou 4
	jecxz mcbnc_skip3
mcbnc_hl1:
	movl   (%edi), %eax
	movl   %eax, (%esi)
	addl   $4, %edi
	addl   $4, %esi
	decw   %cx
	testw  %cx,%cx
	jnz    mcbnc_hl1
mcbnc_skip3:
	 addl  _step1, %edi
	 addl  _step2, %esi
	 decw  %dx
    testw %dx, %dx
	 jne   mcbnc_vl1
mcbnc_vl1e:

    popa");



goto fin;
circle:



asm("
   pusha
	xorl   %ecx,%ecx

	movl  _start1, %edi
   addl  _source, %edi

	movl  _start2, %esi
   addl  _pl_screenbuf, %esi
#----------------------------------------------------------------------------
# antegrapse h2 grammes
#----------------------------------------------------------------------------

   movw  _h2, %dx
	testw  %dx, %dx
	jz mcbc_vl1e
mcbc_vl1:

	movw   _l, %cx
	shrw   $2, %cx
	jecxz mcbc_skip3
mcbc_hl1:
	movl   (%edi), %eax
	movl   %eax, (%esi)
	addl   $4, %edi
	addl   $4, %esi
	decw   %cx
	testw  %cx,%cx
	jnz    mcbc_hl1
mcbc_skip3:
	 addl  _step1, %edi
	 addl  _step2, %esi
	 decw  %dx
	 testw %dx, %dx
	 jnz   mcbc_vl1
mcbc_vl1e:

#----------------------------------------------------------------------------
#   antigrapse l2a pixels
#----------------------------------------------------------------------------
	movw   _l2a, %cx
	jecxz  mcbc_hl2e
mcbc_hl2:
	movb   (%edi), %al
	movb   %al, (%esi)
	incl   %edi
	incl   %esi
	decw   %cx
	testw  %cx,%cx
	jnz    mcbc_hl2
mcbc_hl2e:

#----------------------------------------------------------------------------
#  esi-=pl_screenbufsize
#----------------------------------------------------------------------------
	subl   _pl_screenbufsize, %esi

#----------------------------------------------------------------------------
#  antigrafi ipoloipon l-l2a
#----------------------------------------------------------------------------
	movw   _l,  %cx
	subw   _l2a,%cx

	jecxz  mcbc_hl3e
mcbc_hl3:
	movb   (%edi), %al
	movb   %al, (%esi)
	incl   %edi
	incl   %esi
	decw   %cx
	testw  %cx,%cx
	jnz    mcbc_hl3
mcbc_hl3e:

	addl  _step1,%edi
	addl  _step2,%esi	  # epomeni grammi


#----------------------------------------------------------------------------
#  antegrafi ipoloipon h-h2 grammon
#----------------------------------------------------------------------------
    movw   _h,	%dx
    subw   _h2, %dx
    decw   %dx

    testw %dx, %dx
	 jz    mcbc_vl2e

mcbc_vl2:
	movw   _l, %cx
	shrw   $2, %cx
	jecxz mcbc_skip23
mcbc_hl21:
	movl   (%edi), %eax
	movl   %eax, (%esi)
	addl   $4, %edi
	addl   $4, %esi
	decw   %cx
	testw  %cx,%cx
	jnz    mcbc_hl21
mcbc_skip23:
	 addl  _step1, %edi
	 addl  _step2, %esi
	 decw  %dx
	 testw %dx, %dx
	 jnz   mcbc_vl2
mcbc_vl2e:

    popa");


fin:
return;
}


//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------

// memory circular buffer to video circular buffer
void Mcb2Vcbsolid(long fromofs,unsigned short fromx,unsigned short fromy,
			   long toofs, unsigned short tox,unsigned short toy,
				unsigned short len,unsigned short hei)
{
   long end1,end2;
   long diff1, diff2;
   long clipsize1,clipsize2;
   long tmp;


 fromofs<<=2;  // gia simvatotita me to modex einai /4
 toofs<<=2;  // gia simvatotita me to modex einai /4
   // dose times stis katholikes metavlites
   l=len;
   h=hei;
   step1=pl_screenbuflen-l;
   step2=pl_videolen-l;
   start1=fromofs + fromy*pl_screenbuflen + fromx;
   if (start1>=pl_screenbufsize) start1-=pl_screenbufsize;
   start2=toofs + toy*pl_videolen + tox;
   if (start2>=pl_videosize) start2-=pl_videosize;
   /////////


   end1=start1 + (hei-1)*pl_screenbuflen + (len-1);
   end2=start2 + (hei-1)*pl_videolen + (len-1);

   diff1=end1 - (pl_screenbufsize - 1);
   diff2=end2 - (pl_videosize - 1);



   // lathos ta source kai to den exoun to idio mikos grammis
   // den mporei na metrithei pio tha teleiosei prota mono
   // me ti sigkrisi ton diff

   if (diff1 <= 0)
   if (diff2 <= 0) goto nocircle;
   else  // diff2 > 0 , fromfirst=0
   {
    clipsize2=pl_videosize - start2;
    h1 = clipsize2 / pl_videolen;
    l1 = clipsize2 % pl_videolen;
    if (l1>len) l1=len;
    fromfirst=0;
    goto circle1;
   }

   // diff1 > 0

   if (diff2 <= 0)
   {
    clipsize1=pl_screenbufsize - start1;
    h1= clipsize1 / pl_screenbuflen;
    l1= clipsize1 % pl_screenbuflen;
    if (l1>len) l1=len;
    fromfirst=1;

    goto circle1;
   }
   // diff2 > 0

   clipsize1=pl_screenbufsize - start1;
   h1= clipsize1 / pl_screenbuflen;
   l1= clipsize1 % pl_screenbuflen;

   clipsize2=pl_videosize - start2;
   h2 = clipsize2 / pl_videolen;
   l2a= clipsize2 % pl_videolen;


   fromfirst= ( (h1<h2) || ((h1==h2) && (l1<=l2a)) );
   if (!fromfirst)
   {
     tmp=h1; h1=h2; h2=tmp;
     tmp=l1; l2a=l1; l1=tmp;
   }

   goto circle2;    // kai i dio buffers temnontai



nocircle:

asm("   pusha
	pushw %fs
	xorl   %ecx,%ecx

	movw  _pl_videoselector,%ax
	movw  %ax,%fs

   movl  _pl_screenbuf, %edi
	addl  _start1, %edi

	movl  _start2, %esi

#----------------------------------------------------------------------------
# antegrapse h grammes
#----------------------------------------------------------------------------

	movw  _h, %dx

	testw  %dx, %dx
	jz cbnc_vl1e
cbnc_vl1:
	movw   _l, %cx

	shrw   $1, %cx
	jnc    cbnc_skip1
	movb   (%edi), %al
	movb   %al, %fs:(%esi)
	incl   %edi
	incl   %esi
cbnc_skip1:
	shrw   $1, %cx
	jnc    cbnc_skip2
	movw   (%edi), %ax
	movw   %ax, %fs:(%esi)
	addl   $2, %edi
	addl   $2, %esi
cbnc_skip2:
	jecxz cbnc_skip3
cbnc_hl1:
	movl   (%edi), %eax
	movl   %eax, %fs:(%esi)
	addl   $4, %edi
	addl   $4, %esi
	decw   %cx
	testw  %cx,%cx
	jnz    cbnc_hl1
cbnc_skip3:
	 addl  _step1, %edi
	 addl  _step2, %esi
	 decw  %dx
    testw %dx, %dx
	 jne   cbnc_vl1
cbnc_vl1e:

    popw %fs
    popa");


goto fin;


circle2:
/*
 parametroi pou tha ipologisoume (edi: from  esi: to)
 h1:  se poia grammi, (se sxesi me to fromx) arxizei i tomi me to telos
      tou from buffer
 l1:  posa pixel na antigrapso se auti ti grammi. Afou antigrafoun l1 pixel
      sti sinexeia "edi"-=pl_screenbufsize stamataei i antigafi.
 h2:  se poia grammi, (se sxesi me to fromx) arxizei i tomi me to telos
      tou "to" buffer.
 l2a: posa pixel na antigrapso protou theso "esi"-=pl_videosize
 l2b: posa pixel na antigrapso protou theso esi += videostep

 o algorithmos exei os eksis:
 1) antegrapse h1 oloklires grammes
 2) antegrapse l1 pixel, kane "edi"-=pl_screenbufsize
 3) an i trexousa grammi den einai h2 antegrapse kai ta ipoloipa len-l1 pixel
    kai pigaine sti epomeni grammi
 4) mexri i trexousa grammi na ginei h2 antegrafe grammes.
    antegrapse l2a pixels, these esi-=pl_videosize antegrapse l2b pixels
    these esi+=videostep kai
 5) antegrafe grammes mexri tin teleutaia
*/


 if (l1>len) l1=len;

 if (h2==h1)  // stin idia grammi temnontai kai oi 2 buffers ?
   if (l2a > len)    // i tomi einai se keno xoro
   {
    l2a=len-l1;  // antegrapse osa perisepsan apo to l1
    l2b=0;	     // kai tipota allo
    }
   else
   {
     l2b= len-l2a; // posa menoun gia na simplirothei i grammi
     l2a-=l1;	   // idi tha exoun antigrafei l1 logo tou from
   }
 else
 {
  l2b=0;
  if (l2a>len) l2a=len;
 }



asm("   pusha
	pushw %fs
	xorl   %ecx,%ecx

	movw  _pl_videoselector,%ax
	movw  %ax,%fs

	movl  _start1, %edi
   addl  _pl_screenbuf, %edi

   movl  _start2, %esi

#----------------------------------------------------------------------------
# antegrapse h1 grammes
#----------------------------------------------------------------------------

	xorw  %dx, %dx	    ## dx trexousa grammi

	cmpw  %dx, _h1
	je cb12_vl1e
cb12_vl1:

	movw   _l, %cx

	shrw   $1, %cx
	jnc    cb12_skip1
	movb   (%edi), %al
	movb   %al, %fs:(%esi)
	incl   %edi
	incl   %esi
cb12_skip1:
	shrw   $1, %cx
	jnc    cb12_skip2
	movw   (%edi), %ax
	movw   %ax, %fs:(%esi)
	addl   $2, %edi
	addl   $2, %esi
cb12_skip2:
	jecxz cb12_skip3
cb12_hl1:
	movl   (%edi), %eax
	movl   %eax, %fs:(%esi)
	addl   $4, %edi
	addl   $4, %esi
	decw   %cx
	testw  %cx,%cx
	jnz    cb12_hl1
cb12_skip3:
	 addl  _step1, %edi
	 addl  _step2, %esi
	 incw  %dx
	 cmpw  %dx, _h1
	 jne   cb12_vl1
cb12_vl1e:

#----------------------------------------------------------------------------
#####  antigrapse l1 pixels
#----------------------------------------------------------------------------
	movw   _l1, %cx
	jecxz  cb12_hl2e
cb12_hl2:
	movb   (%edi), %al
	movb   %al, %fs:(%esi)
	incl   %edi
	incl   %esi
	decw   %cx
	testw  %cx,%cx
	jnz    cb12_hl2
cb12_hl2e:

#----------------------------------------------------------------------------
#  an fromfirst edi-=pl_screenbufsize else esi-=pl_videosize
#----------------------------------------------------------------------------
   cmpb   $0,_fromfirst
   je	  cb12_videofirst1

	subl   _pl_screenbufsize, %edi
   jmp	  cb12_skipvideo1

cb12_videofirst1:
   subl   _pl_videosize,  %esi
cb12_skipvideo1:
#----------------------------------------------------------------------------
#  elegxos an i trexousa grammi einai h2 kai antigrafi ipoloipon l-l1
#----------------------------------------------------------------------------
	cmp _h2, %dx
	jz  cb12_skiprest

	movw   _l, %cx
	subw   _l1,%cx

	jecxz  cb12_hl3e
cb12_hl3:
	movb   (%edi), %al
	movb   %al, %fs:(%esi)
	incl   %edi
	incl   %esi
	decw   %cx
	testw  %cx,%cx
	jnz    cb12_hl3
cb12_hl3e:
	incw   %dx
	addl  _step1,%edi
	addl  _step2,%esi
cb12_skiprest:

#----------------------------------------------------------------------------
#  Mexri i trexousa grammi na ginei h2 antegrafe grammes
#----------------------------------------------------------------------------
	cmpw   %dx, _h2
	je    cb12_vl2e

cb12_vl2:
	movw   _l, %cx

	shrw   $1, %cx
	jnc    cb12_skip21
	movb   (%edi), %al
	movb   %al, %fs:(%esi)
	incl   %edi
	incl   %esi
cb12_skip21:
	shrw   $1, %cx
	jnc    cb12_skip22
	movw   (%edi), %ax
	movw   %ax, %fs:(%esi)
	addl   $2, %edi
	addl   $2, %esi
cb12_skip22:
	jecxz cb12_skip23
cb12_hl21:
	movl   (%edi), %eax
	movl   %eax, %fs:(%esi)
	addl   $4, %edi
	addl   $4, %esi
	decw   %cx
	testw  %cx,%cx
	jnz    cb12_hl21
cb12_skip23:
	 addl  _step1, %edi
	 addl  _step2, %esi
	 incw  %dx
	 cmpw  %dx, _h2
	 jne   cb12_vl2
cb12_vl2e:

#----------------------------------------------------------------------------
# antegrapse l2a pixels
#----------------------------------------------------------------------------
	movw   _l2a, %cx
	jecxz  cb12_hl4e
cb12_hl4:
	movb   (%edi), %al
	movb   %al, %fs:(%esi)
	incl   %edi
	incl   %esi
	decw   %cx
	testw  %cx,%cx
	jnz    cb12_hl4
cb12_hl4e:

#----------------------------------------------------------------------------
#  an fromfirst esi-=pl_videosize else edi-=pl_screenbufsize
#----------------------------------------------------------------------------
   cmpb   $0, _fromfirst
   je	  cb12_videosecond

	subl   _pl_videosize, %esi
   jmp	  cb12_skipscreenbuf

cb12_videosecond:
	subl   _pl_screenbufsize, %edi

cb12_skipscreenbuf:
#----------------------------------------------------------------------------
# antegrapse l2b pixels
#----------------------------------------------------------------------------
	movw   _l2b, %cx
	jecxz  cb12_hl5e
cb12_hl5:
	movb   (%edi), %al
	movb   %al, %fs:(%esi)
	incl   %edi
	incl   %esi
	decw   %cx
	testw  %cx,%cx
	jnz    cb12_hl5
cb12_hl5e:

	incw   %dx
	addl  _step1,%edi
	addl  _step2,%esi

#----------------------------------------------------------------------------
#  antegrafe grammes mexri to telos
#----------------------------------------------------------------------------
	cmpw   %dx, _h
	je    cb12_vl3e

cb12_vl3:
	movw   _l, %cx

	shrw   $1, %cx
	jnc    cb12_skip31
	movb   (%edi), %al
	movb   %al, %fs:(%esi)
	incl   %edi
	incl   %esi
cb12_skip31:
	shrw   $1, %cx
	jnc    cb12_skip32
	movw   (%edi), %ax
	movw   %ax, %fs:(%esi)
	addl   $2, %edi
	addl   $2, %esi
cb12_skip32:
	jecxz cb12_skip33
cb12_hl31:
	movl   (%edi), %eax
	movl   %eax, %fs:(%esi)
	addl   $4, %edi
	addl   $4, %esi
	decw   %cx
	testw  %cx,%cx
	jnz    cb12_hl31
cb12_skip33:
	addl  _step1, %edi
	addl  _step2, %esi
	incw  %dx
	cmpw  %dx, _h
	jne   cb12_vl3
cb12_vl3e:

	popw  %fs
	popa");

goto fin;



circle1:


asm("   pusha
	pushw %fs
	xorl   %ecx,%ecx

	movw  _pl_videoselector,%ax
	movw  %ax,%fs

	movl  _start1, %edi
   addl  _pl_screenbuf, %edi

   movl  _start2, %esi

#----------------------------------------------------------------------------
# antegrapse h1 grammes
#----------------------------------------------------------------------------


   movw   _h1, %dx
   testw  %dx, %dx
	jz cb1_vl1e
cb1_vl1:

	movw   _l, %cx

	shrw   $1, %cx
	jnc    cb1_skip1
	movb   (%edi), %al
	movb   %al, %fs:(%esi)
	incl   %edi
	incl   %esi
cb1_skip1:
	shrw   $1, %cx
	jnc    cb1_skip2
	movw   (%edi), %ax
	movw   %ax, %fs:(%esi)
	addl   $2, %edi
	addl   $2, %esi
cb1_skip2:
	jecxz cb1_skip3
cb1_hl1:
	movl   (%edi), %eax
	movl   %eax, %fs:(%esi)
	addl   $4, %edi
	addl   $4, %esi
	decw   %cx
	testw  %cx,%cx
	jnz    cb1_hl1
cb1_skip3:
	 addl  _step1, %edi
	 addl  _step2, %esi
	 decw  %dx
	 testw	%dx, %dx
	 jnz   cb1_vl1
cb1_vl1e:

#      pusha; pushl  $65; call _putchar; popl %eax; popa;
#----------------------------------------------------------------------------
#  antigrapse l1 pixels
#----------------------------------------------------------------------------
	movw   _l1, %cx
#      pusha; pushl  $66; call _putchar; popl %eax; popa;
	jecxz  cb1_hl2e
#      pusha; pushl  $67; call _putchar; popl %eax; popa;
cb1_hl2:
	movb   (%edi), %al
	movb   %al, %fs:(%esi)
	incl   %edi
	incl   %esi
	decw   %cx
	testw  %cx,%cx
	jnz    cb1_hl2
cb1_hl2e:


#      pusha; pushl  $68; call _putchar; popl %eax; popa;
#----------------------------------------------------------------------------
#  an fromfirst edi-=pl_screenbufsize else esi-=pl_videosize
#----------------------------------------------------------------------------
   cmpb   $0,_fromfirst
   je	  cb1_videofirst1

	subl   _pl_screenbufsize, %edi
   jmp	  cb1_skipvideo1

cb1_videofirst1:
   subl   _pl_videosize,  %esi
cb1_skipvideo1:

#----------------------------------------------------------------------------
#  antigrafi ipoloipon l-l1
#----------------------------------------------------------------------------
	movw   _l, %cx
	subw   _l1,%cx

	jecxz  cb1_hl3e
cb1_hl3:
	movb   (%edi), %al
	movb   %al, %fs:(%esi)
	incl   %edi
	incl   %esi
	decw   %cx
	testw  %cx,%cx
	jnz    cb1_hl3
cb1_hl3e:
	addl  _step1,%edi
	addl  _step2,%esi

#----------------------------------------------------------------------------
#  antegrapse tis ipoloipes grammes (h-h1-1)
#----------------------------------------------------------------------------
	movw  _h, %dx
   subw  _h1,%dx
   decw  %dx

   testw  %dx, %dx
	jz    cb1_vl2e

cb1_vl2:
	movw   _l, %cx

	shrw   $1, %cx
	jnc    cb1_skip21
	movb   (%edi), %al
	movb   %al, %fs:(%esi)
	incl   %edi
	incl   %esi
cb1_skip21:
	shrw   $1, %cx
	jnc    cb1_skip22
	movw   (%edi), %ax
	movw   %ax, %fs:(%esi)
	addl   $2, %edi
	addl   $2, %esi
cb1_skip22:
	jecxz cb1_skip23
cb1_hl21:
	movl   (%edi), %eax
	movl   %eax, %fs:(%esi)
	addl   $4, %edi
	addl   $4, %esi
	decw   %cx
	testw  %cx,%cx
	jnz    cb1_hl21
cb1_skip23:
	 addl  _step1, %edi
	 addl  _step2, %esi
	 decw  %dx
	 testw %dx, %dx
	 jnz   cb1_vl2
cb1_vl2e:
    popw  %fs
    popa
     ");




fin:
 return;
}




