#ifndef info_h
#define info_h

extern FILE *outfile; /* The output file to print to */
#define out(FMT, ARG...) fprintf (outfile, FMT ,##ARG )

extern int __help;    /* --help     Print short help*/
extern int __force;   /* --force    Force the useage of Stonewheel instead of any special handlers */
extern int __stderr;  /* --stderr   Print to standard error instead of standard out */
extern int __verbose; /* --verbose  Don't hold back on the useless information */

int stone_info_omf (char *filename);
int stone_info_stone (char *filename);

void print_hex_file_file (FILE *out, FILE *file, int length, int base, int textoff, int byteperline); /* Print hexadecimal from file input to file output */

int fgetw (FILE *file); /* Read little-endian 16-bit integer */
int fgetd (FILE *file); /* Read little-endian 32-bit integer */

#endif /* info_h */
