#ifndef info_index_header
#define info_index_header

#include "s_array.h"

class info_node
{
public:
info_node & operator=( const info_node & model );
bool operator==( const info_node & other );
bool operator!=( const info_node & other );

String file_name;
String node_name;
int start;
int height;
int viewing_position;
};

class info_file_index
{
public:
 info_file_index();
 info_file_index( const info_file_index & model );
~info_file_index();

bool resize( int new_size );
bool read_file( const char * file_name );
bool write_file( const char * file_name );

info_file_index & operator=( const info_file_index & other );
info_file_index & operator+=( const info_file_index & other );
info_file_index & operator+=( const info_node & new_entry );
operator info_node * () { return _node_array; }

int node_count() { return _node_count; }
info_node & node_entry( int index );

int size();

private:
int         _node_count;
int         _actual_height;
info_node * _node_array;
};

// building index on startup
info_file_index build_file_index( const char * full_path_name );
string_array    get_file_parts( string_array & top_file );
info_file_index build_file_part_index( const char * full_path_name );


#endif
