/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains functions for timing and stop-watches.

*/
#ifndef s_timer_h
#define s_timer_h

#include "s_defs.h"
//allergo.h is for the TIMERS_PER_SECOND in the macros.
#include <allegro.h>

/* Call timer_start. Then call timer_read any number of times to get the
	current time since last call to timer_start. Finally, call timer_stop to
	remove the timer and get the total time.
	Before timer_stop, you could also call timer_pause and timer_continue to
	pause time counting.
*/
extern int timer_start(ulong frequence);
extern ulonglong timer_read_ex(void);
extern ulonglong timer_stop_ex(void);
extern ulonglong timer_pause_ex(void);
extern int timer_unpause(void);
extern inline ulong timer_read(void);
extern inline ulong timer_stop(void);
extern inline ulong timer_pause(void);
extern int timer_mode;

/* Calls back as many times as possible for a time. Returns number of milli-
	seconds on success (can vary depending of how long time the last callback
	took). Returns negative on error (which is if Allegro didn't let the
	function install a timer handler).
*/
extern int callback_time(void(*callback)(int progress), int milliseconds);

#endif
