/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains different functions for saving and loading to files.

*/
#ifndef s_fileio_h
#define s_fileio_h

#include <stdio.h>   //FILE type.
#include <allegro.h> //PACKFILE type.
#include "s_string.h"//TSTRLIST type.
#include "s_defs.h"  //ulong,uchar type.

/* Standard syntax for my functions:
	x before the function name means that it will exit on errors.
	_new after the function name means that the function will malloc/relloc
	 all memory needed itself instead of assuming there is already memory
	 malloced.
*/



//Open a file for reading/writing, exiting on error.
extern FILE *xopenread(const uchar *filename);
extern FILE *openread(const uchar *filename);
extern FILE *xopenwrite(const uchar *filename);
extern FILE *openwrite(const uchar *filename);

/* Cooler fread functions: they exit on error. Also, xfread takes only one
	parameter telling length of data instead of that extremely stupid system
	with size and number of elements.*/
extern void xpack_fread(void *buf,ulong length,PACKFILE *f);
extern void xfread(void *buf,ulong length,FILE *f);

/* superstr functions
	superstr is my format for storing strings on disk. They begin with four
	bytes telling the length (as an unsigned long) of the string. After that
	comes the string, without a zero at the end. This is much faster when
	loading strings than storing them null-terminated.*/
extern int savestr(FILE *f,uchar *text);
extern uchar *loadstr_d(FILE *f,uchar *text);
#define loadstr_new(f)           loadstr_d(f,NULL)
#define loadstr_de(f,buf)        loadstr_d(f,buf)
extern int seekstr(FILE *f);
extern void xsavestr(FILE *f,uchar *text);
extern uchar *xloadstr_d(FILE *f,uchar *text);
#define xloadstr_new(f)          xloadstr_d(f,NULL)
#define xloadstr_de(f,buf)       xloadstr_d(f,buf)
extern void xseekstr(FILE *f);
// superstr functions for Allegro packfiles.
extern int pack_savestr(PACKFILE *f,uchar *text);
extern uchar *pack_loadstr_d(PACKFILE *f,uchar *text);
#define pack_loadstr_new(f)      pack_loadstr_d(f,NULL)
#define pack_loadstr_de(f,buf)   pack_loadstr_d(f,buf)
extern int pack_seekstr(PACKFILE *f);
extern void xpack_savestr(PACKFILE *f,uchar *text);
extern uchar *xpack_loadstr(PACKFILE *f,uchar *text);
#define xpack_loadstr_new(f)     xpack_loadstr_d(f,NULL)
#define xpack_loadstr_de(f,buf)  xpack_loadstr_d(f,buf)
extern void xpack_seekstr(PACKFILE *f);

//strlist functions. A strlist is an array of strings.
extern int loadstrlist(FILE *f,TSTRLIST *sl);
extern void xloadstrlist(FILE *f,TSTRLIST *sl);
extern int savestrlist(FILE *f, TSTRLIST *sl);
extern void xsavestrlist(FILE *f, TSTRLIST *sl);
//strlist functions for Allegro packfiles.
extern int pack_loadstrlist(PACKFILE *f,TSTRLIST *sl);
extern void xpack_loadstrlist(PACKFILE *f,TSTRLIST *sl);
extern int pack_savestrlist(PACKFILE *f, TSTRLIST *sl);
extern void xpack_savestrlist(PACKFILE *f, TSTRLIST *sl);

/* cstr functions
	cstr is the format of string in c: first the string and then a zero at
	the end of it (null-terminated string).*/
extern int savecstr(FILE *f,uchar *text);
extern uchar *loadcstr_de(FILE *f,uchar *text);
extern uchar *loadcstr_new(FILE *f);
extern void xsavecstr(FILE *f,uchar *text);
extern uchar *xloadcstr_de(FILE *f,uchar *text);
extern uchar *xloadcstr_new(FILE *f);


#endif
