/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains mallocing and reallocing functions.

*/

#ifndef s_alloc_c
#define s_alloc_c

#include "s_alloc.h"


void *(*xxmalloc)(int size)=salad_xmalloc;
void *(*xxrealloc)(void *buf, int size)=salad_xrealloc;

/**********************
****               ****
**** salad_xmalloc ****
****               ****
***********************
Mallocs/reallocs and exits if there is no more memory.
*/
void *salad_xmalloc(int size)
{
void *ret;
if(!(ret=malloc(size)))
	exitfail("In function salad_xmalloc: malloc failed.");
return ret;
}
void *salad_xrealloc(void *buf, int size)
{
if(!(buf=realloc(buf,size)))
	exitfail("In function salad_xrealloc: realloc failed.");
return buf;
}


/*****************
****          ****
**** if*alloc ****
****          ****
******************
These are the same as the macros beginning with an underscore, except that
they are functions, not macros. If you want to call them with function
results or complex expressions as parameters, you should use these functions.
*/
void *ifmalloc(void *buf,int length)
{
return buf ? buf : buf=malloc(length);
}
void *ifrealloc(void *buf,int allocmode,int length)
{
return allocmode ? buf : realloc(buf, length);
}
void *ifxmalloc(void *buf,int length)
{
return buf ? buf : buf=xxmalloc(length);
}
void *ifxrealloc(void *buf,int allocmode,int length)
{
return allocmode ? buf : xxrealloc(buf, length);
}



/******************
****           ****
**** strmalloc ****
****           ****
*******************
mallocates memory for a string and puts a 0 at end of it.
Note that you can also use strxmalloc if you want to exit on errors.*/
uchar *strmalloc(long length)
{
uchar *text;
if((text=malloc(length+1)))
	text[length]=0;
return text;
}
/*******************
****            ****
**** strrealloc ****
****            ****
********************
reallocs memory for a string and puts a 0 at end of it.
Note that you can also use strxrealloc if you want to exit on errors.*/
uchar *strrealloc(uchar *text,long length)
{
if((text=realloc(text,length+1)))
	text[length]=0;
return text;
}
/*******************
****            ****
**** strxmalloc ****
****            ****
*******************/
uchar *strxmalloc(long length)
{
uchar *text=xxmalloc(length+1);
text[length]=0;
return text;
}
/********************
****             ****
**** strxrealloc ****
****             ****
********************/
uchar *strxrealloc(uchar *text,long length)
{
(text=xxrealloc(text,length+1))[length]=0;
return text;
}




/********************
****             ****
**** ifstrmalloc ****
****             ****
********************/
uchar *ifstrmalloc(uchar *text,long length)
{
if(text){
	text[length]=0;
	return text;
}
if((text=malloc(length+1)))
	text[length]=0;
return text;
}
/*********************
****              ****
**** ifstrrealloc ****
****              ****
*********************/
uchar *ifstrrealloc(uchar *text,int allocmode,long length)
{
if(allocmode){
	text[length]=0;
	return text;
}
if((text=realloc(text,length+1)))
	text[length]=0;
return text;
}
/*********************
****              ****
**** ifstrxmalloc ****
****              ****
*********************/
uchar *ifstrxmalloc(uchar *text,long length)
{
if(text)
	text[length]=0;
else
	(text=xxmalloc(length+1))[length]=0;
return text;
}
/**********************
****               ****
**** ifstrxrealloc ****
****               ****
**********************/
uchar *ifstrxrealloc(uchar *text,int allocmode,long length)
{
if(allocmode)
	text[length]=0;
else
	(text=xxrealloc(text,length+1))[length]=0;
return text;
}


#endif


