/*
 * This file is part of Pallantir - events kernel for Allegro
 * Version : 0.5
 * Copyright (c) 1997 Dim Zegebart, Moscow Russia.
 * zager@post.comstar.ru
 * http://www.geocities.com/siliconvalley/pines/7817
 * file : dzadial.c
 *
 */

#include "palantir.h"
#include <sys/stat.h>
/*
typedef struct
{ dz_app *app;//application wich wait for string
  device *dev;//port
  int status;
  char call_command[25];
} dialing_string;
#define dstring_(_str_) ({(dialing_string*)(_str_);})
int autodialer_init(void);
dialing_string *comm_port_dialstring_add(device *port,dz_app *app,char *s);
void comm_port_dialstring_remove(device *port,dz_app *app,char *s);
*/

typedef struct
{ device *port;
  int status;
  odlist *dialing_strings;
  odelement *cur_dial;
} port_dialing_string;
#define pdstring_(_str_) ({(port_dialing_string*)(_str_);})
odlist *dialings_list;
int dialing_handler(a_message code,int p1,int p2);
dz_app *adial_app;
static int adial_init=0;

//------------------------ AUTODIALER INIT ---------------------------

int autodialer_init(void)
{ int tmp;

  if (adial_init) return(1); //already installed

  if ((dialings_list=odlist_new())==NULL)
   {
     return(0);
   }

  if (!waiting_strings_init()||!waiting_delimiter_init())
   { lwp_disable;
     free(dialings_list);
     lwp_enable;
     return(0);
   }

  if ((adial_app=dz_app_new("Auto Dialer (comm helper)",16384,1,dialing_handler))==NULL)
   { lwp_disable;
     free(dialings_list);
     lwp_enable;
     return(0);
   }

  adial_init=1;
  return(1);
}

//------------------- COMM PORT DIALSTRING ADD -------------------------

dialing_string *comm_port_dialstring_add(device *dev,dz_app *app,char *s)
{ comm_port *port=dev->device_user_data;
  int tmp;

  odlist *cur_list;

  if (dev==NULL||port==NULL||s==NULL||s[0]==0) return(NULL);
  lwp_disable;
  { odelement *cur=dialings_list->first;
    while (cur!=NULL) //check installed handlers
     { if (pdstring_(cur->data)->port==dev) break;
       cur=cur->next;
     }
    if (cur==NULL) //add handler for new port
     { port_dialing_string *new_port_list=pdstring_(malloc(sizeof(port_dialing_string)));
       if (new_port_list==NULL)
        { lwp_enable;
          return(NULL);
        }
       new_port_list->status=0;
       new_port_list->port=dev;
       if ((new_port_list->dialing_strings=odlist_new())==NULL)
        { free(new_port_list);
          lwp_enable;
          return(NULL);
        }
       if (odlist_insert(dialings_list,new_port_list)==NULL)
        { free(new_port_list->dialing_strings);
          free(new_port_list);
          lwp_enable;
          return(NULL);
        }
       cur_list=new_port_list->dialing_strings;
       new_port_list->status=0;
     }
    else
     cur_list=pdstring_(cur->data)->dialing_strings;
  }
  lwp_disable;
  {
  dialing_string *dstr=dstring_(malloc(sizeof(dialing_string)));

  if (dstr==NULL)
   { free(dstr);
     lwp_enable;
     return(NULL);
   }

  dstr->app=app;
  dstr->dev=dev;
  strcpy(dstr->call_command,s);

//  dstr->status=1;
  if (odlist_insert(cur_list,dstr)==NULL)
   { free(dstr);
     lwp_enable;
     return(NULL);
   }
  dstr->status=0;
  lwp_enable;
//  app_msg_put(adial_app,E_DIALER_START,0,(int)dev);
  return(dstr);
  }
}

odelement *dial_find_port(device *dev)
{ odelement *cur;
  cur=dialings_list->first;
  while (cur!=NULL) //find port
   { if (pdstring_(cur->data)->port==dev) break;
     cur=cur->next;
   }
  return(cur);
}

odelement *dial_find_next_number(odelement *cur_list,dz_app *app)
{ odelement *cur,*cur_dial=pdstring_(cur_list->data)->cur_dial;

  cur=cur_dial->next;
  while (cur)
   { if (dstring_(cur->data)->app==app&&!dstring_(cur->data)->status) break;
     printf("CMD : %d, %s\n",dstring_(cur->data)->status,dstring_(cur->data)->call_command);
     cur=cur->next;
   }
  if (cur)
   { pdstring_(cur_list->data)->cur_dial=cur;
     return(cur);
   }

  cur=pdstring_(cur_list->data)->dialing_strings->first;
  while (cur&&cur!=cur_dial)
   { if (dstring_(cur->data)->app==app&&!dstring_(cur->data)->status&&cur!=cur_dial) break;
     printf("CMD : %d, %s\n",dstring_(cur->data)->status,dstring_(cur->data)->call_command);
     cur=cur->next;
   }
  if (cur==cur_dial&&dstring_(cur->data)->status) cur=NULL;

  pdstring_(cur_list->data)->cur_dial=cur;
  return(cur);

}

void dialer_add_working_strings(device *dev)
{ char ss[2]={'\n',0};
  comm_port_waitstring_add(dev,adial_app,"BUSY"); //(re)install strings
  comm_port_waitstring_add(dev,adial_app,"NO CARRIER");
  comm_port_waitstring_add(dev,adial_app,"NO DIAL TONE");
  comm_port_waitstring_add(dev,adial_app,"NO DIALTONE");
  comm_port_waitstring_add(dev,adial_app,"NO ANSWER");
  comm_port_waitdelimiters_add(dev,adial_app,"CONNECT ",ss);
}

void dialer_remove_working_strings(device *dev)
{ char ss[2]={'\n',0};
  comm_port_waitstring_remove(dev,adial_app,"BUSY"); //(re)install strings
  comm_port_waitstring_remove(dev,adial_app,"NO CARRIER");
  comm_port_waitstring_remove(dev,adial_app,"NO DIAL TONE");
  comm_port_waitstring_remove(dev,adial_app,"NO DIALTONE");
  comm_port_waitstring_remove(dev,adial_app,"NO ANSWER");
  comm_port_waitdelimiter_remove(dev,adial_app,"CONNECT",ss);
}
//------------------- DIALING HANDLER ---------------------

int dialing_handler(a_message code,int p1,int p2)
{ odelement *cur,*cur_list;
  dz_app *app;


//  static dialing_string *dstr;
//  int c;
//  int tmp;
  odelement *cur_dial;
  char *cmd;

  switch (code)
   {
    case E_DIALER_START :
     if ((cur=dial_find_port(dev_(p2)))==NULL) return(1);
     modem_hangup(dev_(p2));
//     if (pdstring_(cur->data)->status==0) return(1); //already dialing
     dialer_add_working_strings(dev_(p2));
     //reseting all status to be an active
     pdstring_(cur->data)->status=0;
     pdstring_(cur->data)->cur_dial=pdstring_(cur->data)->dialing_strings->first;
     cur=pdstring_(cur->data)->dialing_strings->first;
     cur_dial=cur;
     while(cur)
      { dstring_(cur->data)->status=0;
        cur=cur->next;
      }

     cmd=dstring_(cur_dial->data)->call_command;
//     modem_hangup(dev_(p2));
     comm_port_command_send(dev_(p2),cmd);
     break;
    case E_COMM_STRING :
//     printf("\nSTRING : %s\n",wstring_(p1)->string);
     wstring_(p1)->status=0;

     if ((cur_list=dial_find_port(dev_(p2)))==NULL) return(1);
     modem_hangup(dev_(p2));
     if (pdstring_(cur_list->data)->status==1) return(1); //check if active

     app=dstring_(pdstring_(cur_list->data)->cur_dial->data)->app;
//     cur_dial=pdstring_(cur->data)->cur_dial;
     if ((cur=dial_find_next_number(cur_list,app))==NULL) //no more numbers to dial
      { app_msg_put(app,E_DIALER_FINISH,0,(int)dev_(p2));
        return(1);
      }

//     pdstring_(cur_dial->data)->cur_dial=cur;
     cmd=dstring_(cur->data)->call_command;
     comm_port_command_send(dev_(p2),cmd);//dstring_(cur_dial->data)->call_command);
     break;
    case E_DIALER_CONTINUE :
//   printf("CONTINUE\n");
     if ((cur_list=dial_find_port(dev_(p2)))==NULL) return(1);
     modem_hangup(dev_(p2));

     pdstring_(cur_list->data)->status=0;

//     if (pdstring_(cur->data)->status==1) return(1); //check if active

     app=dstring_(pdstring_(cur_list->data)->cur_dial->data)->app;
//     cur_dial=pdstring_(cur->data)->cur_dial;
     if ((cur=dial_find_next_number(cur_list,app))==NULL) //no more numbers to dial
      { app_msg_put(app,E_DIALER_FINISH,0,(int)dev_(p2));
        return(1);
      }
     dialer_add_working_strings(dev_(p2));

//     pdstring_(cur_dial->data)->cur_dial=cur;
     cmd=dstring_(cur->data)->call_command;
     comm_port_command_send(dev_(p2),cmd);//dstring_(cur_dial->data)->call_command);
     break;
    case E_COMM_DELIMITERS :
//     wdelimiter_(p1)->status=0;
     if ((cur_list=dial_find_port(dev_(p2)))==NULL) return(1);

     if (pdstring_(cur_list->data)->status==1) return(1);
     pdstring_(cur_list->data)->status=1;

     cur_dial=pdstring_(cur_list->data)->cur_dial;
     if (dstring_(cur_dial->data)->status==1) return(1);

     dialer_remove_working_strings(dev_(p2));
     app=dstring_(cur_dial->data)->app;
     dstring_(cur_dial->data)->status=1;
     app_msg_put(app,E_DIALER_CONNECT,(int)wdelimiter_(p1)->rcv_buffer,(int)cur_dial->data);

     break;
    default :
      break;
  }
  return(1);
}

//------------------- COMM PORT DIALING STRING REMOVE ---------------------

void comm_port_dialingstring_remove(device *dev,dz_app *task,char *s)
{ odelement *cur;
  odlist *dlist;
  int tmp;
  if (dev==NULL) return;

  cur=dialings_list->first;
  while (cur!=NULL) //find port
   { if (pdstring_(cur->data)->port==dev) break;
     else cur=cur->next;
   }
  if (cur==NULL) return;

  dlist=pdstring_(cur->data)->dialing_strings;
  cur=dlist->first;

  while (cur!=NULL)
   { if (dstring_(cur->data)->app==task)
      { if (strcmp(dstring_(cur->data)->call_command,s)==0)
         { lwp_disable;
           odlist_remove(dlist,cur->data);
           free(cur->data);
           lwp_enable;
           return;
         }
      }
     cur=cur->next;
   }
}
